% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnetLM.R
\name{predict.nnetLM}
\alias{predict.nnetLM}
\title{Performs a forward pass}
\usage{
\method{predict}{nnetLM}(object, newdata)
}
\arguments{
\item{object}{a trained network object of class "nnetLM"}

\item{newdata}{Matrix of predictors}
}
\value{
a numeric vector with predicted values
}
\description{
Performs a forward pass
}
\examples{
set.seed(123)
x <- seq(-10, 10, by = 0.1)
y <- sin(x) + rnorm(length(x), mean = 0, sd = 0.1)
X <- matrix(x, nrow = length(x), ncol = 1)
hidden <- c(10)
linear <- function(x) x
actFn <- list(tanh, linear)
nnet.obj <- nnetLM(X, y, hidden, actFn)
nnet.obj <- train.nnetLM(nnet.obj,50)
pred.nnetLM <- predict(nnet.obj, X)
}
