% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSgmicmen.R
\name{SSgmicmen}
\alias{SSgmicmen}
\alias{gmicmen}
\title{self start for a generalized Michaelis-Menten function}
\usage{
gmicmen(x, y0, ymax, c, k)

SSgmicmen(x, y0, ymax, c, k)
}
\arguments{
\item{x}{input vector}

\item{y0}{the lowest value}

\item{ymax}{the maximum value}

\item{c}{parameter controlling the shape of the function}

\item{k}{parameter controlling the time for maximum value}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

gmicmen: vector of the same length as x using the modified Michaelis-Menten function
}
\description{
Self starter for a Michealis-Menten function with parameters
}
\details{
# This is a modification of an equation that appears in the paper in the details.
# It is not clear how useful it is.

Source: A generalized Michaelis-Menten equation for the analysis of growth. Lopez et al. J. Anim. Sci. 2000. 78:1816-1828.
}
\examples{
\donttest{
require(ggplot2)
set.seed(123)
x <- 1:30
y <- gmicmen(x, 1, 10, 0.7, 10) + rnorm(30, 0, 0.01)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSgmicmen(x, y0, ymax, c, k), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
## Confidence intervals
confint(fit)

## Different value for c
y <- gmicmen(x, 1, 10, 5, 10) + rnorm(30, 0, 0.01)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSgmicmen(x, y0, ymax, c, k), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
## Confidence intervals
confint(fit)
}

}
