% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.operator.R
\name{step_iiv_ka}
\alias{step_iiv_ka}
\title{Evaluate inter-individual variability on Ka}
\usage{
step_iiv_ka(
  dat,
  start.mod = NULL,
  search.space = "oralbase",
  no.cores = NULL,
  param_table = NULL,
  penalty.control = NULL,
  precomputed_results_file = NULL,
  filename = "test",
  foldername = NULL,
  .modEnv = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{start.mod}{A named integer vector specifying the starting model
code. If NULL, a base model is generated using \code{base_model()}.}

\item{search.space}{Character, one of "ivbase" or "oralbase". Default is "oralbase".}

\item{no.cores}{Integer. Number of CPU cores to use. If NULL, uses
\code{rxode2::getRxThreads()}.}

\item{param_table}{Optional data frame of initial parameter estimates. If NULL,
the table is generated by \code{auto_param_table()}.}

\item{penalty.control}{A list of penalty control parameters defined by
\code{penaltyControl()}, specifying penalty values used for model diagnostics
during fitness evaluation.}

\item{precomputed_results_file}{Optional path to a CSV file of previously computed
model results used for caching.}

\item{filename}{Optional character string used as a prefix for output files.
Defaults to "test".}

\item{foldername}{Character string specifying the name of the folder to be
created in the current working directory to store intermediate results.
If NULL, a temporary path is used via \code{tempdir()}.}

\item{.modEnv}{An optional environment used to store intermediate
results across model runs.}

\item{verbose}{Logical. If TRUE, print progress messages.}

\item{...}{Additional arguments forwarded to \code{mod.run()}.}
}
\value{
A list with the following elements:
\itemize{
\item results_table: A data.frame summarizing the evaluated models.
\item best_code: A named integer vector representing the selected
model code.
\item best_row: A one-row data.frame corresponding to the selected
model.
}
}
\description{
Runs candidate models with and without IIV on \eqn{K_a} by modifying only the
corresponding random-effect setting in the current model code.
}
\details{
This step is executed only when the search space is "oralbase" and the
starting model code does not already include inter-individual
variability on \eqn{K_a}. If these conditions are not met, no model
comparison is performed.
}
\examples{
\donttest{
  dat <- theo_sd
  param_table <- initialize_param_table()
  param_table$init[param_table$Name == "lcl"] <- log(2)
  param_table$init[param_table$Name == "lvc"] <- log(30)
  penalty.control <- penaltyControl()
  penalty.control$penalty.terms <-
    c("rse", "theta", "covariance", "shrinkage", "omega")
  start.mod <- base_model("oralbase")
  step_iiv_ka(
    dat = dat,
    start.mod = start.mod,
    search.space = "oralbase",
    param_table = param_table,
    filename = "step_etaka_test",
    penalty.control = penalty.control,
    saem.control = nlmixr2est::saemControl(logLik = TRUE,nBurn=15,nEm=15)
  )
}

}
\seealso{
\code{\link{mod.run}}, \code{\link{base_model}}, \code{\link{penaltyControl}}
}
\author{
Zhonghui Huang
}
