% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TeamEDGE.R
\name{team_edge_skating_distance}
\alias{team_edge_skating_distance}
\title{Access the EDGE skating distance statistics for a team, season, game type,
and category}
\usage{
team_edge_skating_distance(
  team = 1,
  season = "now",
  game_type = "",
  category = "details"
)
}
\arguments{
\item{team}{integer ID (e.g., 21), character full name (e.g., 'Colorado
Avalanche'), OR three-letter code (e.g., 'COL'); see \code{\link[=teams]{teams()}} for
reference; ID is preferable as there now exists duplicate three-letter codes
(i.e., 'UTA' for 'Utah Hockey Club' and 'Utah Mammoth')}

\item{season}{integer in YYYYYYYY (e.g., 20242025); see
\code{\link[=team_edge_seasons]{team_edge_seasons()}} for reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
'playoff'/'post'; see \code{\link[=team_edge_seasons]{team_edge_seasons()}} for reference; most functions
will NOT support pre-season}

\item{category}{character of 'd'/'details' or 'l'/'l10'/'last 10'}
}
\value{
data.frame with one row per combination of strength state and
position (category = 'details') or game (category = 'last 10')
game
}
\description{
\code{team_edge_skating_distance()} retrieves the EDGE skating distance statistics for a team, season, game type, and category as a \code{data.frame} where each row represents combination of strength state and position and includes detail on team identity, affiliation, and matchup-side context, ranking movement, points pace, and division/conference position signals, and NHL EDGE style tracking outputs and relative-performance context.
}
\examples{
COL_L10_skating_distance_regular_20242025 <- team_edge_skating_distance(
  team      = 21,
  season    = 20242025,
  game_type = 2,
  category  = 'L'
)
}
