\name{calculate_pre}
\alias{calculate_pre}
\title{Calculate Percentage Relative Efficiency (PRE)}
\usage{
calculate_pre(result_all_mse)
}
\arguments{
\item{result_all_mse}{A list containing MSE results from \code{\link{calculate_all_mse_neutrosophic}}}
}
\value{
A list containing PRE values for each estimator type:
\itemize{
  \item PRE_t0 - PRE for standard MSE estimator
  \item PRE_t1 - PRE for ratio-adjusted MSE estimator
  \item PRE_t2 - PRE for kurtosis-adjusted MSE estimator
  \item PRE_exp - PRE for exponential MSE estimator
  \item PRE_r - Reference value (100) for regression estimator
}
}
\description{
Computes the Percentage Relative Efficiency (PRE) of different MSE estimators
relative to the regression estimator MSE. PRE values greater than 100 indicate
better efficiency than the regression estimator, while values less than 100
indicate worse efficiency.
}
\examples{
data(japan_neutro)
metrics <- compute_all_metrics(japan_neutro)
mse_results <- calculate_all_mse_neutrosophic(
  0.01, 0.02,
  metrics$mean_interval_Y[1], metrics$mean_interval_Y[2],
  metrics$mean_interval_X[1], metrics$mean_interval_X[2],
  metrics$cv_interval_X[1], metrics$cv_interval_X[2],
  metrics$cv_interval_Y[1], metrics$cv_interval_Y[2],
  metrics$correlation_results[1], metrics$correlation_results[2],
  metrics$kurtosis_interval_X[1], metrics$kurtosis_interval_X[2]
)
pre_results <- calculate_pre(mse_results)
print(pre_results)
}
\seealso{
\code{\link{calculate_all_mse_neutrosophic}} for generating the input MSE values
}
