% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcellate.R
\name{parcels_to_vertices}
\alias{parcels_to_vertices}
\title{Map parcel data back to vertices}
\usage{
parcels_to_vertices(parcel_data, labels, fill = NA_real_)
}
\arguments{
\item{parcel_data}{Named numeric vector of parcel values
(names match labels).}

\item{labels}{Integer vector of parcel labels. \code{0} and \code{NA} are medial wall.}

\item{fill}{Value for medial wall vertices (default: \code{NA_real_}).}
}
\value{
Numeric vector of \code{length(labels)}.
}
\description{
Expands parcel-level values to a vertex-level vector using parcellation
labels.
}
\examples{
parcel_data <- c("1" = 10, "2" = 20)
labels <- c(1L, 1L, 2L, 2L, 0L)
parcels_to_vertices(parcel_data, labels)
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
