% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls.R
\name{generate_nulls}
\alias{generate_nulls}
\title{Generate null distributions for brain map data}
\usage{
generate_nulls(
  data,
  method = c("burt2020", "moran", "spin_vasa", "spin_hungarian", "alexander_bloch",
    "baum", "cornblath", "burt2018"),
  n_perm = 1000L,
  distmat = NULL,
  coords = NULL,
  parcellation = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{data}{Numeric vector of brain map values.}

\item{method}{Character string specifying the null model method.}

\item{n_perm}{Integer number of null permutations to generate.}

\item{distmat}{Distance matrix (required for \code{"burt2020"}, \code{"burt2018"},
and \code{"moran"}).}

\item{coords}{List with \verb{$lh} and \verb{$rh} coordinate matrices
(required for spin methods).}

\item{parcellation}{Integer vector of parcel labels (required for \code{"baum"}
and \code{"cornblath"}).}

\item{seed}{Optional integer seed for reproducibility.}

\item{...}{Additional arguments passed to the specific null method
(e.g. \code{rotation} for spin methods, \code{kernel} for moran/burt2020).}
}
\value{
A \link{null_distribution} object.
}
\description{
Dispatches to the appropriate null model method for generating
spatially-constrained surrogate brain maps.
}
\examples{
data <- rnorm(100)
distmat <- as.matrix(dist(seq_len(100)))
nd <- generate_nulls(data, method = "moran", distmat = distmat, n_perm = 10L)
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
