% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.netSEMp2.R
\name{plot.netSEMp2}
\alias{plot.netSEMp2}
\title{Plotting of netSEM diagram}
\usage{
\method{plot}{netSEMp2}(
  x,
  cutoff = NULL,
  latent = NULL,
  title = "netSEMp2",
  plot.save = FALSE,
  filename = NULL,
  style = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class "netSEMp2", the returned list from \code{netSEMp2}.}

\item{cutoff}{A threshold value for adjusted R-squared. The maximum number of cutoff is 3.}

\item{latent}{The latent variable that corresponds to the mechanic variable. The default is NULL.}

\item{title}{The title of the plot. Default value is "netSEMp2".}

\item{plot.save}{True/False, it saves the network diagram plot as png file. The default is false.}

\item{filename}{A character string naming a file to save as a png file.}

\item{style}{True/False, it plots the first interval in the network diagram with dotted weak line. The default is True.}

\item{...}{A S3 generic/method consistency.}
}
\value{
An html style plot of pairwise relationship pathway diagram between exogenous variables and an endogenous variable. 
Arrows show relationships between each variable with given statistical relations along the connection lines.
}
\description{
Plot netSEMp2 result
plot.netSEMp2 plots a structural equation network model diagram, fitted under principle 2, based on best functional form for each selected pairwise variable.
}
\examples{
\dontrun{
# Load acrylic data set
data(acrylic)

# Build a netSEMp2 model
ans <- netSEMp2(acrylic, "IrradTot", "YI")

# Plot the network model with a title
plot(ans, cutoff = c(0.3,0.6,0.8), title = "Acrylic")

\donttest{
# plot the network diagram and save file
plot(ans, cutoff = c(0.3,0.6,0.8), 
     plot.save = TRUE, 
     filename = "acrylic-netSEMp2")
}
}
}
\seealso{
\link[netSEM]{netSEMp2}
}
