% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learners.R
\name{lnr_xgboost}
\alias{lnr_xgboost}
\title{XGBoost Learner}
\usage{
lnr_xgboost(data, formula, weights = NULL, nrounds = 1000, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{weights}{Observation weights; see \code{?lm}}

\item{nrounds}{The max number of boosting iterations}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
A prediction function that accepts \code{newdata},
which returns predictions (a numeric vector of values, one for each row
of \code{newdata}).
}
\description{
A wrapper for \code{xgboost::xgboost()} for use in \code{nadir::super_learner()}.
}
\examples{
lnr_xgboost(mtcars, mpg ~ hp)(mtcars)
}
\seealso{
learners
}
