% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{list_all_tables}
\alias{list_all_tables}
\title{List All Tables Visible to the Connection}
\usage{
list_all_tables(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A \code{dbplyr} lazy tibble with columns:
\itemize{
\item \code{table_catalog} — database/catalog name
\item \code{table_schema}  — schema name
\item \code{table_name}    — table name
}
}
\description{
Returns a lazy tibble of all tables visible to the current connection by
querying \code{information_schema.tables} (across all catalogs/databases and
schemas).
}
\details{
The result is a \code{dbplyr} lazy table (\code{tbl_dbi}). Use \code{collect()} to bring
results into R as a local tibble.
}
\seealso{
Other db-list: 
\code{\link{list_all_databases}()},
\code{\link{list_current_schemas}()},
\code{\link{list_current_tables}()},
\code{\link{list_extensions}()},
\code{\link{list_fns}()},
\code{\link{list_setting}()},
\code{\link{list_shares}()}
}
\concept{db-list}
