% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegr.R
\name{autoplot.LearnerRegr}
\alias{autoplot.LearnerRegr}
\title{Plot for Regression Learners}
\usage{
\method{autoplot}{LearnerRegr}(
  object,
  type = "prediction",
  task,
  grid_points = 100L,
  expand_range = 0,
  theme = theme_minimal(),
  ...
)
}
\arguments{
\item{object}{(\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Train task.}

\item{grid_points}{(integer(1))\cr
Number of grid points per feature dimension.}

\item{expand_range}{(numeric(1))\cr
Expand the range of the grid.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3:LearnerRegr]{mlr3::LearnerRegr}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"prediction"} (default): Decision boundary of the learner and the true class labels.
}
}
\examples{
\donttest{
task = tsk("mtcars")$select(c("am", "carb"))
learner = lrn("regr.rpart")
learner$train(task)

autoplot(learner, type = "prediction", task)
}
}
