% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpLearnerPICVPlus.R
\name{mlr_pipeops_learner_pi_cvplus}
\alias{mlr_pipeops_learner_pi_cvplus}
\alias{PipeOpLearnerPICVPlus}
\title{Wrap a Learner into a PipeOp with Cross-validation Plus Confidence Intervals as Predictions}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOp}}.
}
\description{
Wraps an \code{\link[mlr3:Learner]{mlr3::Learner}} into a \code{\link{PipeOp}}.

Inherits the \verb{$param_set} (and therefore \verb{$param_set$values}) from the \code{\link[mlr3:Learner]{Learner}} it is constructed from.

Using \code{PipeOpLearnerPICVPlus}, it is possible to embed a \code{\link[mlr3:Learner]{mlr3::Learner}} into a \code{\link{Graph}}.
\code{PipeOpLearnerPICVPlus} can then be used to perform cross validation plus (or jackknife plus).
During training, \code{PipeOpLearnerPICVPlus} performs cross validation on the training data.
During prediction, the models from the training stage are used to construct predictive confidence intervals for the prediction data based on
out-of-fold residuals and out-of-fold predictions.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpLearnerPICVPlus$new(learner, id = NULL, param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{learner} :: \code{\link[mlr3:LearnerRegr]{LearnerRegr}}
\code{\link[mlr3:LearnerRegr]{LearnerRegr}} to use for the cross validation models in the Cross Validation Plus method.
This argument is always cloned; to access the \code{\link[mlr3:Learner]{Learner}} inside \code{PipeOpLearnerPICVPlus} by-reference, use \verb{$learner}.\cr
\item \code{id} :: \code{character(1)}
Identifier of the resulting  object, internally defaulting to the \code{id} of the \code{\link[mlr3:Learner]{Learner}} being wrapped.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction.
Default is \code{list()}.
}
}

\section{Input and Output Channels}{

\code{PipeOpLearnerPICVPlus} has one input channel named \code{"input"}, taking a \code{\link[mlr3:Task]{Task}} specific to the \code{\link[mlr3:Learner]{Learner}}
type given to \code{learner} during construction; both during training and prediction.

\code{PipeOpLearnerPICVPlus} has one output channel named \code{"output"}, producing \code{NULL} during training and a \code{\link[mlr3:PredictionRegr]{PredictionRegr}}
during prediction.

The output during prediction is a \code{\link[mlr3:PredictionRegr]{PredictionRegr}} with \code{predict_type} \code{quantiles} on the prediction input data.
The \code{alpha} and \code{1 - alpha} quantiles are the \code{quantiles} of the prediction interval produced by the cross validation plus method.
The \code{response} is the median of the prediction of all cross validation models on the prediction data.
}

\section{State}{

The \verb{$state} is a named \code{list} with members:
\itemize{
\item \code{cv_model_states} :: \code{list}\cr
List of the state of each cross validation model created by the \code{\link[mlr3:Learner]{Learner}}'s \verb{$.train()} function during resampling with method \code{"cv"}.
\item \code{residuals} :: \code{data.table}\cr
\code{data.table} with columns \code{fold} and \code{residual}. Lists the Regression residuals for each observation and cross validation fold.
}

This state is given the class \code{"pipeop_learner_cv_state"}.
}

\section{Parameters}{

The parameters of the \code{\link[mlr3:Learner]{Learner}} wrapped by this object, as well as:
\itemize{
\item \code{folds} :: \code{numeric(1)}\cr
Number of cross validation folds. Initialized to 3.
\item \code{alpha} :: \code{numeric(1)}\cr
Quantile to use for the cross validation plus prediction intervals. Initialized to 0.05.
}
}

\section{Internals}{

The \verb{$state} is updated during training.
}

\section{Fields}{

Fields inherited from \code{\link{PipeOp}}, as well as:
\itemize{
\item \code{learner} :: \code{\link[mlr3:Learner]{Learner}}\cr
\code{\link[mlr3:Learner]{Learner}} that is being wrapped.
Read-only.
\item \code{learner_model} :: \code{\link[mlr3:Learner]{Learner}} or \code{list}\cr
If the \code{PipeOpLearnerPICVPlus} has been trained, this is a \code{list} containing the \code{\link[mlr3:Learner]{Learner}}s of the cross validation models.
Otherwise, this contains the \code{\link[mlr3:Learner]{Learner}} that is being wrapped.
Read-only.
\item \code{predict_type}\cr
Predict type of the \code{PipeOpLearnerPICVPlus}, which is always \verb{"response"  "quantiles"}.
This can be different to the predict type of the \code{\link[mlr3:Learner]{Learner}} that is being wrapped.
}
}

\section{Methods}{

Methods inherited from \code{\link{PipeOp}}.
}

\examples{
\dontshow{if (requireNamespace("rpart")) withAutoprint(\{ # examplesIf}
library("mlr3")

task = tsk("mtcars")
learner = lrn("regr.rpart")
lrncvplus_po = mlr_pipeops$get("learner_pi_cvplus", learner)

lrncvplus_po$train(list(task))
lrncvplus_po$predict(list(task))
\dontshow{\}) # examplesIf}
}
\references{
Barber RF, Candes EJ, Ramdasa A, Tibshirani RJ (2021).
\dQuote{Predictive inference with the jackknife+.}
\emph{Annals of Statistics}, \bold{49}, 486--507.
\doi{10.1214/20-AOS1965}.
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEncodePL}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_adas}},
\code{\link{mlr_pipeops_blsmote}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_classweightsex}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_decode}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encodeplquantiles}},
\code{\link{mlr_pipeops_encodepltree}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_info}},
\code{\link{mlr_pipeops_isomap}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_learner_quantiles}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nearmiss}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_rowapply}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_smotenc}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_splines}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tomek}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}

Other Meta PipeOps: 
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_learner_cv}},
\code{\link{mlr_pipeops_learner_quantiles}}
}
\concept{Meta PipeOps}
\concept{PipeOps}
