% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-index.R
\name{gintervals.2d.convert_to_indexed}
\alias{gintervals.2d.convert_to_indexed}
\title{Convert 2D interval set to indexed format}
\usage{
gintervals.2d.convert_to_indexed(
  set.name = NULL,
  remove.old = FALSE,
  force = FALSE
)
}
\arguments{
\item{set.name}{name of 2D interval set to convert}

\item{remove.old}{if TRUE, removes old per-chromosome files after successful conversion}

\item{force}{if TRUE, re-converts even if already in indexed format}
}
\value{
invisible NULL
}
\description{
Converts a per-chromosome interval set to indexed format
(intervals2d.dat + intervals2d.idx) which reduces file descriptor usage.
}
\details{
The indexed format stores all chromosome pairs in a single intervals2d.dat file
with an intervals2d.idx index file. This dramatically reduces file descriptor
usage, especially for genomes with many chromosomes (N*(N-1)/2 files to just 2).

Only non-empty pairs are stored in the index, avoiding O(N^2) space overhead.

The conversion process:
\enumerate{
  \item Scans directory for existing per-pair files
  \item Creates temporary intervals2d.dat.tmp and intervals2d.idx.tmp files
  \item Concatenates all per-pair files into intervals2d.dat.tmp
  \item Builds index with pair offsets and checksums
  \item Atomically renames temporary files to final names
  \item Optionally removes old per-pair files
}

The indexed format is 100% backward compatible with all existing misha functions.
}
\examples{
\dontrun{
# Convert a 2D interval set
gintervals.2d.convert_to_indexed("my_2d_intervals")

# Convert and remove old files
gintervals.2d.convert_to_indexed("my_2d_intervals", remove.old = TRUE)

# Force re-conversion
gintervals.2d.convert_to_indexed("my_2d_intervals", force = TRUE)
}

}
