% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-sequence.R
\name{gdb.export_fasta}
\alias{gdb.export_fasta}
\title{Export a database genome as FASTA}
\usage{
gdb.export_fasta(
  file = NULL,
  groot = NULL,
  line_width = 80L,
  chunk_size = 1000000L,
  overwrite = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{file}{Output FASTA file path}

\item{groot}{Optional database root path. If NULL, uses current database.}

\item{line_width}{Number of bases per FASTA line. Default: 80.}

\item{chunk_size}{Number of bases to extract per chunk while writing.
Default: 1000000.}

\item{overwrite}{Logical. If TRUE, overwrite existing output file.
Default: FALSE.}

\item{verbose}{Logical. If TRUE, prints progress messages. Default: FALSE.}
}
\value{
Invisibly returns \code{file}.
}
\description{
Writes all contigs from a misha database to a multi-FASTA file.
}
\details{
By default, the currently active database is used. You can also provide
\code{groot} to export another database without changing the caller's active
database.
}
\examples{
\dontrun{
gdb.init_examples()
out <- tempfile(fileext = ".fa")
gdb.export_fasta(out)
head(readLines(out))
}
}
\seealso{
\code{\link{gdb.init}}, \code{\link{gseq.extract}}
}
