% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{daemons}
\alias{daemons}
\title{Daemons (Set Persistent Processes)}
\usage{
daemons(
  n,
  url = NULL,
  remote = NULL,
  dispatcher = TRUE,
  ...,
  sync = FALSE,
  seed = NULL,
  serial = NULL,
  tls = NULL,
  pass = NULL,
  .compute = NULL
)
}
\arguments{
\item{n}{(integer) number of daemons to launch.}

\item{url}{(character) URL at which to listen for daemon connections, e.g.
'tcp://hostname:5555'. Use scheme 'tls+tcp://' for secure TLS connections
(see Distributed Computing section). \code{\link[=host_url]{host_url()}} may be used to construct
a valid URL.}

\item{remote}{(configuration) for launching remote daemons, generated by
\code{\link[=ssh_config]{ssh_config()}}, \code{\link[=cluster_config]{cluster_config()}}, or \code{\link[=remote_config]{remote_config()}}.}

\item{dispatcher}{(logical) whether to use dispatcher for optimal FIFO
scheduling. See Dispatcher section below.}

\item{...}{(daemon arguments) passed to \code{\link[=daemon]{daemon()}} when launching daemons.
Includes \code{asyncdial}, \code{autoexit}, \code{cleanup}, \code{output}, \code{maxtasks},
\code{idletime}, \code{walltime}, and \code{tlscert}.}

\item{sync}{(logical) whether to evaluate mirai synchronously in the current
process for testing and debugging. When \code{TRUE}, other arguments except
\code{seed} and \code{.compute} are disregarded.}

\item{seed}{(integer) for reproducible random number generation. \code{NULL}
(default) initializes L'Ecuyer-CMRG RNG streams per daemon (statistically
sound, non-reproducible). An integer value instead initializes a stream per
mirai, allowing reproducible results independent of which daemon evaluates
it.}

\item{serial}{(configuration) for custom serialization of reference objects
(e.g. Arrow Tables, torch tensors), created by \code{\link[=serial_config]{serial_config()}}. Requires
dispatcher. \code{NULL} applies any configurations from \code{\link[=register_serial]{register_serial()}}.}

\item{tls}{(character) for secure TLS connections. Either a file path to
PEM-encoded TLS certificate (possibly followed by other certificates in a
validation chain) and private key, or a length-2 vector of (certificate,
private key). \code{NULL} auto-generates single-use credentials.}

\item{pass}{(function) returning the password for an encrypted \code{tls} private
key. Use a function rather than a direct value for security.}

\item{.compute}{(character) name of the compute profile. Each profile has its
own independent set of daemons. \code{NULL} (default) uses the 'default'
profile.}
}
\value{
Invisibly, logical \code{TRUE} when creating daemons and \code{FALSE} when
resetting.
}
\description{
Set daemons, or persistent background processes, to receive \code{\link[=mirai]{mirai()}}
requests. Specify \code{n} to create daemons on the local machine. Specify \code{url}
to receive connections from remote daemons (for distributed computing across
the network). Specify \code{remote} to optionally launch remote daemons via a
remote configuration. Dispatcher (enabled by default) ensures optimal
scheduling.
}
\details{
Use \code{daemons(0)} to reset daemon connections:
\itemize{
\item All connected daemons and/or dispatchers exit automatically.
\item Any as yet unresolved 'mirai' will return an 'errorValue' 19
(Connection reset).
\item \code{\link[=mirai]{mirai()}} reverts to the default behaviour of creating a new
background process for each request.
}

If the host session ends, all connected dispatcher and daemon processes
automatically exit as soon as their connections are dropped.

Calling \code{\link[=daemons]{daemons()}} implicitly resets any existing daemons for the compute
profile with \code{daemons(0)}. Instead, \code{\link[=launch_local]{launch_local()}} or \code{\link[=launch_remote]{launch_remote()}} may
be used to add daemons at any time without resetting daemons.
}
\section{Local Daemons}{


Setting daemons, or persistent background processes, is typically more
efficient as it removes the need for, and overhead of, creating new processes
for each mirai evaluation. It also provides control over the total number of
processes at any one time.

Supply the argument \code{n} to set the number of daemons. New background
\code{\link[=daemon]{daemon()}} processes are automatically launched on the local machine
connecting back to the host process, either directly or via dispatcher.
}

\section{Dispatcher}{


By default \code{dispatcher = TRUE} launches a background process running
\code{\link[=dispatcher]{dispatcher()}}. Dispatcher connects to daemons on behalf of the host, queues
tasks, and ensures optimal FIFO scheduling. Dispatcher also enables (i) mirai
cancellation using \code{\link[=stop_mirai]{stop_mirai()}} or when using a \code{.timeout} argument to
\code{\link[=mirai]{mirai()}}, and (ii) the use of custom serialization configurations.

With \code{dispatcher = FALSE}, daemons connect directly to the host and tasks
are distributed round-robin, with tasks queued at each daemon. Optimal
scheduling is not guaranteed, as tasks can queue at one daemon while others
remain idle. However, this is the most lightweight option, suited to
similar-length tasks or when concurrent tasks do not exceed available
daemons.
}

\section{Distributed Computing}{


Specify \code{url} as a character string to allow tasks to be distributed across
the network (\code{n} is only required in this case if also providing a launch
configuration to \code{remote}).

The host / dispatcher listens at this URL, utilising a single port, and
\code{\link[=daemon]{daemon()}} processes dial in to this URL. Host / dispatcher automatically
adjusts to the number of daemons actually connected, allowing dynamic
upscaling / downscaling.

The URL should have a 'tcp://' scheme, such as 'tcp://10.75.32.70:5555'.
Switching the URL scheme to 'tls+tcp://' automatically upgrades the
connection to use TLS. The auxiliary function \code{\link[=host_url]{host_url()}} may be used to
construct a valid host URL based on the computer's IP address.

IPv6 addresses are also supported and must be enclosed in square brackets
\verb{[]} to avoid confusion with the final colon separating the port. For
example, port 5555 on the IPv6 loopback address ::1 would be specified as
'tcp://[::1]:5555'.

Specifying the wildcard value zero for the port number e.g. 'tcp://[::1]:0'
will automatically assign a free ephemeral port. Use \code{\link[=status]{status()}} to inspect
the actual assigned port at any time.

Specify \code{remote} with a call to \code{\link[=ssh_config]{ssh_config()}}, \code{\link[=cluster_config]{cluster_config()}} or
\code{\link[=remote_config]{remote_config()}} to launch (programatically deploy) daemons on remote
machines, from where they dial back to \code{url}. If not launching daemons,
\code{\link[=launch_remote]{launch_remote()}} may be used to generate the shell commands for manual
deployment.
}

\section{Compute Profiles}{


If \code{NULL}, the \code{"default"} compute profile is used. Providing a character
value for \code{.compute} creates a new compute profile with the name specified.
Each compute profile retains its own daemons settings and operates
independently. Some usage examples follow:

\strong{local / remote} daemons may be set by specifying a host URL and
\code{.compute} as \code{"remote"}, creating a new compute profile. Subsequent
\code{\link[=mirai]{mirai()}} calls may then be sent for local computation by not specifying the
\code{.compute} argument, or for remote computation to connected daemons by
specifying the \code{.compute} argument as \code{"remote"}.

\strong{cpu / gpu} some tasks may require access to different types of daemon,
such as those with GPUs. In this case, \code{daemons()} may be called to set up
host URLs for CPU-only daemons and for those with GPUs, specifying the
\code{.compute} argument as \code{"cpu"} and \code{"gpu"} respectively. By supplying the
\code{.compute} argument to subsequent \code{\link[=mirai]{mirai()}} calls, tasks may be sent to
either \code{cpu} or \code{gpu} daemons as appropriate.

Note: further actions such as resetting daemons via \code{daemons(0)} should
be carried out with the desired \code{.compute} argument specified.
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Create 2 local daemons (using dispatcher)
daemons(2)
info()
# Reset to zero
daemons(0)

# Create 2 local daemons (not using dispatcher)
daemons(2, dispatcher = FALSE)
info()
# Reset to zero
daemons(0)

# Set up dispatcher accepting TLS over TCP connections
daemons(url = host_url(tls = TRUE))
info()
# Reset to zero
daemons(0)

# Set host URL for remote daemons to dial into
daemons(url = host_url(), dispatcher = FALSE)
info()
# Reset to zero
daemons(0)

# Use with() to evaluate with daemons for the duration of the expression
with(
  daemons(2),
  {
    m1 <- mirai(Sys.getpid())
    m2 <- mirai(Sys.getpid())
    cat(m1[], m2[], "\n")
  }
)

\dontrun{

# Launch daemons on remotes 'nodeone' and 'nodetwo' using SSH
# connecting back directly to the host URL over a TLS connection:
daemons(
  url = host_url(tls = TRUE),
  remote = ssh_config(c('ssh://nodeone', 'ssh://nodetwo'))
)

# Launch 4 daemons on the remote machine 10.75.32.90 using SSH tunnelling:
daemons(
  n = 4,
  url = local_url(tcp = TRUE),
  remote = ssh_config('ssh://10.75.32.90', tunnel = TRUE)
)

}
\dontshow{\}) # examplesIf}
# Synchronous mode
# mirai are run in the current process - useful for testing and debugging
daemons(sync = TRUE)
m <- mirai(Sys.getpid())
daemons(0)
m[]

# Synchronous mode restricted to a specific compute profile
daemons(sync = TRUE, .compute = "sync")
with_daemons("sync", {
  m <- mirai(Sys.getpid())
})
daemons(0, .compute = "sync")
m[]

}
\seealso{
\code{\link[=with_daemons]{with_daemons()}} and \code{\link[=local_daemons]{local_daemons()}} for managing the compute
profile used locally.
}
