% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimalistGODB.R
\name{buildGODatabase}
\alias{buildGODatabase}
\title{buildGODatabase}
\usage{
buildGODatabase(goa, gobasic, dir = NULL, verbose = FALSE)
}
\arguments{
\item{goa}{character string path name to downloaded goa_human.gaf}

\item{gobasic}{character string path name to downloaded go-basic.obo}

\item{dir}{character string path name to directory to hold subdirectory GODB_RDATA}

\item{verbose}{Boolean if TRUE print out some diagnostic info}
}
\value{
returns no value but has side effect of saving GOGOA3 to a subdirectory
}
\description{
driver to build GO database
}
\details{
download goa_human.gaf from https://current.geneontology.org/products/pages/downloads.html
download go-basic.obo from https://geneontology.org/docs/download-ontology/
parameter dir should be omitted or NULL except for the developer harvesting the updated .RData DBs

The output GOGOA was saved as an .RData file.
This was too large for CRAN.
It is available from https://github.com/barryzee/GO/tree/main/databases
}
\examples{
\dontrun{
# replace my path names for goa and gobasic with your own!!
# these were obtained from the download sites listed in 'details' section
goa<-"~/goa_human.gaf"
gobasic<-"~/go-basic.obo"
buildGODatabase(goa,gobasic,dir="~/",verbose=TRUE)
# > dim(GOGOA)
# [1] 720139      5
# > GOGOA[1:5,]
#      HGNC          GO           RELATION      NAME                    ONTOLOGY            
# [1,] "NUDT4B"      "GO:0003723" "enables"     "RNA binding"           "molecular_function"
# [2,] "NUDT4B"      "GO:0005515" "enables"     "protein binding"       "molecular_function"
# [3,] "NUDT4B"      "GO:0046872" "enables"     "metal ion binding"     "molecular_function"
# [4,] "NUDT4B"      "GO:0005829" "located_in"  "cytosol"               "cellular_component"
# [5,] "TRBV20OR9-2" "GO:0002376" "involved_in" "immune system process" "biological_process"
}

# here is a small example that you can run
f1<-system.file("extdata","goa_human.small.gaf",package="minimalistGODB")
f2<-system.file("extdata","go-basic.small.obo",package="minimalistGODB")
buildGODatabase(f1,f2,verbose=TRUE)

}
