% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGWRSAR.R
\name{MGWRSAR}
\alias{MGWRSAR}
\title{Estimation of linear and local linear model with spatial autocorrelation model (mgwrsar).}
\usage{
MGWRSAR(formula, data, coords, fixed_vars = NULL, kernels, H,
Model = "GWR", control = list())
}
\arguments{
\item{formula}{a formula.}

\item{data}{a dataframe or a spatial dataframe (sp package).}

\item{coords}{default NULL, a dataframe or a matrix with coordinates, not
required if data is a spatial dataframe.}

\item{fixed_vars}{a vector with the names of spatiallay constant coefficient for
mixed model. All other variables present in formula are supposed to be spatially
varying. If empty or NULL (default), all variables in formula are supposed to be
spatially varying.}

\item{kernels}{A vector containing the kernel types. Possible types:
rectangle ("rectangle"), bisquare ("bisq"), tricube ("tcub"), epanechnikov ("epane"), gaussian
("gauss")) .}

\item{H}{vector containing the bandwidth parameters for the kernel functions.}

\item{Model}{character containing the type of model: Possible values are "OLS",
"SAR", "GWR" (default), "MGWR" , "MGWRSAR_0_0_kv","MGWRSAR_1_0_kv",
"MGWRSAR_0_kc_kv", "MGWRSAR_1_kc_kv", "MGWRSAR_1_kc_0". See Details for more
explanation.}

\item{control}{list of extra control arguments for MGWRSAR wrapper - see Details below}
}
\value{
MGWRSAR returns an object of class mgwrsar with at least the following components:
\describe{
\item{Betav}{ matrix of coefficients of dim(n,kv) x kv.}
\item{Betac}{ vector of coefficients of length kc.}
\item{Model}{ The sum of square residuals.}
\item{Y}{ The dependent variable.}
\item{XC}{ The explanatory variables with constant coefficients.}
\item{XV}{ The explanatory variables with varying coefficients.}
\item{X}{ The explanatory variables.}
\item{W}{ The spatial weight matrix for spatial dependence.}
\item{isgcv}{ if gcv has been computed.}
\item{edf}{ The estimated degrees of freedom.}
\item{formula}{The formula.}
\item{data}{ The dataframe used for computation.}
\item{Method}{ The type of model.}
\item{coords}{ The spatial coordinates of observations.}
\item{H}{ The bandwidth vector.}
\item{fixed_vars}{The names of constant coefficients.}
\item{kernels}{ The kernel vector.}
\item{SSR}{ The sum of square residuals.}
\item{residuals}{ The vector of residuals.}
\item{fit}{ the vector of fitted values.}
\item{sev}{ local standard error of parameters.}
\item{get_ts}{Boolean, if trace of hat matrix Tr(S) should be stored.}
\item{NN}{ Maximum number of neighbors for weights computation}
}
MGWRSAR is is a wrapper function for estimating linear and local linear model
with spatial autocorrelation that  allows to estimate the following models :
\eqn{y=\beta_c X_c+\,\epsilon_i} (OLS)

\eqn{y=\beta_v(u_i,v_i) X_v+\,\epsilon_i} (GWR)

\eqn{y=\beta_c X_c+\beta_v(u_i,v_i) X_v+\,\epsilon_i} (MGWR)

\eqn{y=\lambda Wy+\beta_c X_c+\,\epsilon_i} (MGWR-SAR(0,k,0))

\eqn{y=\lambda Wy+\beta_v(u_i,v_i)X_v+\,\epsilon_i} (MGWR-SAR(0,0,k))

\eqn{y=\lambda Wy+\beta_c X_c+\beta_v(u_i,v_i)X_v+\,\epsilon_i} (MGWR-SAR(0,k_c,k_v))

\eqn{y=\lambda(u_i,v_i) Wy+\beta_c X_c+\,\epsilon_i} (MGWR-SAR(1,k,0))

\eqn{y=\lambda(u_i,v_i)Wy+\beta_v(u_i,v_i)X_v+\,\epsilon_i} (MGWR-SAR(1,0,k))

\eqn{y=\lambda(u_i,v_i)Wy+\beta_cX_c+\beta_v(u_i,v_i)X_v+\,\epsilon_i} (MGWR-SAR(1,k_c,k_v))

When model imply spatial autocorrelation, a row normalized spatial weight matrix must be provided.
2SLS and Best 2SLS method can be used.
When model imply local regression, a bandwidth and a kernel type must be provided. Optimal bandwidth can be estimated
using goldens_search_bandwid function.
When model imply mixed local regression, the names of stationary covariates must be provided.

#' In addition to the ability of considering spatial autocorrelation in GWR/MGWR like models,
MGWRSAR function introduces several useful technics for estimating local regression with space coordinates:
\itemize{
\item{it uses RCCP and RCCPeigen code that speed up computation and allows parallel computings;}
\item{it allows to drop out variables with not enough local variance in local regression, which allows to consider dummies in GWR/MGWR framework without trouble.}
\item{it allows to drop out local outliers in local regression.}
\item{it allows to consider additional variable for kernel, including  time (asymetric kernel) and categorical variables (see Li and Racine 2010). Experimental version.}
}
}
\description{
MGWRSAR is is a wrapper function for estimating linear and local linear models
with spatial autocorrelation (SAR models with spatially varying coefficients).
}
\details{
\describe{
\item{Z}{A matrix of variables for genralized kernel product, default NULL.}
\item{W}{A row-standardized spatial weight matrix for Spatial
 Aurocorrelation, default NULL.}
\item{Type}{Verbose mode, default FALSE.}
\item{adaptive}{A vector of boolean to choose adaptive version for
 each kernel.}
\item{kernel_w}{The type of kernel for computing W, default NULL.}
\item{h_w}{The bandwidth value for computing W, default 0.}
\item{Method}{Estimation method for computing the models with Spatial
Dependence. '2SLS' or 'B2SLS', default '2SLS'.}
\item{TP}{Avector of target points, default NULL.}
\item{ncore}{Number of CPU core for parallel computation, default 1}
\item{isgcv}{If TRUE, compute a LOOCV criteria, default FALSE.}
\item{verbose}{Verbose mode, default FALSE.}
}
}
\examples{
\donttest{
 library(mgwrsar)
 ## loading data example
 data(mydata)
 coords=as.matrix(mydata[,c("x","y")])
 ## Creating a spatial weight matrix (sparce dgCMatrix)
 ## of 4 nearest neighbors with 0 in diagonal
 W=kernel_matW(H=4,kernels='rectangle',coords=coords,NN=4,adaptive=TRUE,
 diagnull=TRUE)
 mgwrsar_0_kc_kv<-MGWRSAR(formula = 'Y_mgwrsar_0_kc_kv~X1+X2+X3', data = mydata,
 coords=coords, fixed_vars='X2',kernels=c('gauss'),H=20, Model = 'MGWRSAR_0_kc_kv',
 control=list(SE=FALSE,adaptive=TRUE,W=W))
 summary(mgwrsar_0_kc_kv)
}
}
\references{
Geniaux, G. and Martinetti, D. (2017). A new method for dealing simultaneously with spatial autocorrelation and spatial heterogeneity in regression models. Regional Science and Urban Economics. (https://doi.org/10.1016/j.regsciurbeco.2017.04.001)

McMillen, D. and Soppelsa, M. E. (2015). A conditionally parametric probit model of
microdata land use in chicago. Journal of Regional Science, 55(3):391-415.

Loader, C. (1999). Local regression and likelihood, volume 47. springer New York.

Franke, R. and Nielson, G. (1980). Smooth interpolation of large sets of scattered data.
International journal for numerical methods in engineering, 15(11):1691-1704.
}
\seealso{
golden_search_bandwidth, summary, plot, predict, kernel_matW
}
