% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_sl_summary.R
\name{format_sl_summary}
\alias{format_sl_summary}
\title{Prepare data for baseline characteristic table}
\usage{
format_sl_summary(
  outdata,
  display_col = c("n", "prop", "total"),
  digits_prop = 1,
  display_stat = c("mean", "sd", "se", "median", "q1 to q3", "range")
)
}
\arguments{
\item{outdata}{A metadata object created by \code{\link[=prepare_sl_summary]{prepare_sl_summary()}}.}

\item{display_col}{Column wants to display on the table.
The term could be selected from \code{c("n", "prop", "total")}.}

\item{digits_prop}{Number of digits for proportion columns.}

\item{display_stat}{A vector of statistics term name.
The term name could be selected from
\code{c("mean", "sd", "se", "median", "q1 to q3", "range", "q1", "q3", "min", "max")}.}
}
\value{
A list of analysis raw datasets.
}
\description{
Prepare data for baseline characteristic table
}
\examples{
meta <- meta_sl_example()

meta |>
  prepare_sl_summary(population = "apat", analysis = "base_char", parameter = "age;gender") |>
  format_sl_summary()
}
