% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_as_value.R
\name{recode_as_value}
\alias{recode_as_value}
\title{Recode a value as another value}
\usage{
recode_as_value(
  df,
  value = NULL,
  replacement_value = NULL,
  subset_cols = NULL,
  pattern_type = NULL,
  pattern = NULL,
  case_sensitive = FALSE,
  ...
)
}
\arguments{
\item{df}{A data.frame object for which recoding is to be done.}

\item{value}{The value/vector of values to convert.}

\item{replacement_value}{New value.}

\item{subset_cols}{An optional character vector to define columns for which changes 
are required.}

\item{pattern_type}{One of contains', 'starts_with' or 'ends_with'.}

\item{pattern}{A character pattern to match}

\item{case_sensitive}{Defaults to FALSE. Patterns are case insensitive if TRUE}

\item{...}{Other arguments to other functions}
}
\value{
An object of the same class as x with values changed to `NA`.
}
\description{
This provides a convenient way to convert a number/value to 
another value.
}
\examples{
head(recode_as_value(airquality,
value=c(67,118),replacement=NA, pattern_type="starts_with",pattern="S|O"))
}
