% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{size_corr}
\alias{size_corr}
\title{Sample Size for Testing Pearson's correlation}
\usage{
size_corr(
  r1,
  r0,
  alpha = 0.05,
  power = 0.8,
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{r1}{(\code{numeric})\cr expected correlation coefficient of the evaluated assay.}

\item{r0}{(\code{numeric})\cr acceptable correlation coefficient of the evaluated assay.}

\item{alpha}{(\code{numeric})\cr type-I-risk, \eqn{\alpha}.}

\item{power}{(\code{numeric})\cr Power of test, equal to 1 minus type-II-risk (\eqn{\beta}).}

\item{alternative}{(\code{string})\cr string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less".}
}
\value{
an object of \code{size} class that contains the sample size and relevant parameters.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function performs sample size computation for testing Pearson's
correlation, using uses Fisher's classic z-transformation to
normalize the distribution of Pearson's correlation coefficient.
}
\examples{
size_corr(r1 = 0.95, r0 = 0.9, alpha = 0.025, power = 0.8, alternative = "greater")
}
\references{
Fisher (1973, p. 199).
}
\seealso{
\code{\link[=size_one_prop]{size_one_prop()}} \code{\link[=size_ci_one_prop]{size_ci_one_prop()}} \code{\link[=size_ci_corr]{size_ci_corr()}}
}
