% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fancyMask.R
\name{fancyMask}
\alias{fancyMask}
\title{Generate ggplot2 layers for a labeled cluster mask}
\usage{
fancyMask(
  maskTable,
  ratio = NULL,
  limits.expand = ifelse(label, 0.1, 0.05),
  linewidth = 1,
  shape.expand = linewidth * unit(-1, "pt"),
  cols = "inherit",
  label = TRUE,
  label.fontsize = 10,
  label.buffer = unit(0, "cm"),
  label.fontface = "plain",
  label.margin = margin(2, 2, 2, 2, "pt")
)
}
\arguments{
\item{maskTable}{A data.frame of mask coordinates. The first two
columns are interpreted as x/y coordinates (in that order). Must contain
at least the columns \code{cluster} (a factor) and \code{group} (grouping identifier
passed to \code{geom_mark_shape()}).}

\item{ratio}{Optional aspect ratio passed to \code{ggplot2::coord_cartesian()}.
Use \code{1} for equal scaling. Default is \code{NULL} (no fixed ratio).}

\item{limits.expand}{Numeric scalar giving the fraction of the x/y range to
expand on both sides when setting plot limits. Default is \code{0.1} with labels and 0.05 with no labels.}

\item{linewidth}{Line width passed to \code{geom_mark_shape()} for the
outline. Default is \code{1}.}

\item{shape.expand}{Expansion or contraction applied to the marked shapes,
passed to \code{geom_mark_shape(expand = ...)}. Default is
\code{unit(-linewidth, "pt")}.}

\item{cols}{Color specification for cluster outlines (and labels). One of:
\itemize{
\item \code{"inherit"} (default) — inherits colors from the discrete color scale
of the plot that \code{fancyMask()} is added to (e.g., from
\code{scale_color_manual()}). Falls back to black if no discrete color
scale is found.
\item A palette function that accepts a single integer \code{n} and returns \code{n}
colors (e.g., \code{scales::hue_pal()}, \code{rainbow}).
\item A single color string — applied to every cluster.
\item An unnamed character vector of length equal to the number of clusters —
colors are assigned to clusters in factor-level order.
\item A named character vector — names must match cluster levels; order does
not matter.
}}

\item{label}{Boolean flag wheter the labels should be displayed.}

\item{label.fontsize}{Label font size passed to \code{geom_mark_shape()}.
Default is \code{10}.}

\item{label.buffer}{Label buffer distance passed to
\code{geom_mark_shape()}. Default is \code{unit(0, "cm")}.}

\item{label.fontface}{Label font face passed to
\code{geom_mark_shape()}. Default is \code{"plain"}.}

\item{label.margin}{Label margin passed to
\code{geom_mark_shape()}. Default is \code{margin(2, 2, 2, 2, "pt")}.}
}
\value{
A list of ggplot2 components suitable for adding to a plot with \code{+},
containing a \code{ggplot2::coord_cartesian()} specification and a
\code{geom_mark_shape()} layer. When \code{cols = "inherit"}, returns an
opaque object whose colors are resolved when added to a plot.
}
\description{
Convenience helper that returns a list of ggplot2 components
that draws polygon-like outlines and
places cluster labels.
The plotting limits are expanded (via \code{limits.expand}) to provide
extra room for labels.
}
\details{
The first two columns of \code{maskTable} are used as x/y coordinates. Cluster
labels are taken from \code{maskTable$cluster}. Shapes are grouped by
\code{maskTable$group}.
}
\examples{
data("exampleMascarade")
maskTable <- generateMask(dims=exampleMascarade$dims,
                          clusters=exampleMascarade$clusters)
library(ggplot2)
basePlot <- ggplot(do.call(cbind, exampleMascarade)) +
    geom_point(aes(x=UMAP_1, y=UMAP_2, color=GNLY)) +
    scale_color_gradient2(low = "#404040", high="red") +
    theme_classic()

basePlot + fancyMask(maskTable, ratio=1, cols=scales::hue_pal())

}
\seealso{
\itemize{
\item \code{geom_mark_shape()}
}
}
