% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_plot_orchestrator.R
\name{Ggplot2PlotOrchestrator}
\alias{Ggplot2PlotOrchestrator}
\title{Plot Orchestrator Class}
\description{
Plot Orchestrator Class

Plot Orchestrator Class
}
\details{
This class orchestrates the detection and processing of multiple layers
in a ggplot2 object. It analyzes each layer individually and combines
the results into a comprehensive interactive plot.
}
\keyword{-}
\keyword{Unified}
\keyword{all}
\keyword{by}
\keyword{creation}
\keyword{internal}
\keyword{layer}
\keyword{plot}
\keyword{processor}
\keyword{types}
\keyword{used}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{plot}}{The ggplot2 object being processed}

\item{\code{layers}}{List of detected layer information}

\item{\code{layer_processors}}{List of layer-specific processors}

\item{\code{combined_data}}{Combined data from all layers}

\item{\code{combined_selectors}}{Combined selectors from all layers}

\item{\code{layout}}{Layout information from the plot}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{plot}}{The ggplot2 object being processed}

\item{\code{layers}}{List of detected layer information}

\item{\code{layer_processors}}{List of layer-specific processors}

\item{\code{combined_data}}{Combined data from all layers}

\item{\code{combined_selectors}}{Combined selectors from all layers}

\item{\code{layout}}{Layout information from the plot}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Ggplot2PlotOrchestrator-new}{\code{Ggplot2PlotOrchestrator$new()}}
\item \href{#method-Ggplot2PlotOrchestrator-detect_layers}{\code{Ggplot2PlotOrchestrator$detect_layers()}}
\item \href{#method-Ggplot2PlotOrchestrator-analyze_single_layer}{\code{Ggplot2PlotOrchestrator$analyze_single_layer()}}
\item \href{#method-Ggplot2PlotOrchestrator-determine_layer_type}{\code{Ggplot2PlotOrchestrator$determine_layer_type()}}
\item \href{#method-Ggplot2PlotOrchestrator-create_layer_processors}{\code{Ggplot2PlotOrchestrator$create_layer_processors()}}
\item \href{#method-Ggplot2PlotOrchestrator-create_layer_processor}{\code{Ggplot2PlotOrchestrator$create_layer_processor()}}
\item \href{#method-Ggplot2PlotOrchestrator-create_unified_layer_processor}{\code{Ggplot2PlotOrchestrator$create_unified_layer_processor()}}
\item \href{#method-Ggplot2PlotOrchestrator-process_layers}{\code{Ggplot2PlotOrchestrator$process_layers()}}
\item \href{#method-Ggplot2PlotOrchestrator-extract_layout}{\code{Ggplot2PlotOrchestrator$extract_layout()}}
\item \href{#method-Ggplot2PlotOrchestrator-combine_layer_results}{\code{Ggplot2PlotOrchestrator$combine_layer_results()}}
\item \href{#method-Ggplot2PlotOrchestrator-generate_maidr_data}{\code{Ggplot2PlotOrchestrator$generate_maidr_data()}}
\item \href{#method-Ggplot2PlotOrchestrator-get_gtable}{\code{Ggplot2PlotOrchestrator$get_gtable()}}
\item \href{#method-Ggplot2PlotOrchestrator-get_layout}{\code{Ggplot2PlotOrchestrator$get_layout()}}
\item \href{#method-Ggplot2PlotOrchestrator-get_combined_data}{\code{Ggplot2PlotOrchestrator$get_combined_data()}}
\item \href{#method-Ggplot2PlotOrchestrator-get_layer_processors}{\code{Ggplot2PlotOrchestrator$get_layer_processors()}}
\item \href{#method-Ggplot2PlotOrchestrator-get_layers}{\code{Ggplot2PlotOrchestrator$get_layers()}}
\item \href{#method-Ggplot2PlotOrchestrator-is_patchwork_plot}{\code{Ggplot2PlotOrchestrator$is_patchwork_plot()}}
\item \href{#method-Ggplot2PlotOrchestrator-is_faceted_plot}{\code{Ggplot2PlotOrchestrator$is_faceted_plot()}}
\item \href{#method-Ggplot2PlotOrchestrator-process_faceted_plot}{\code{Ggplot2PlotOrchestrator$process_faceted_plot()}}
\item \href{#method-Ggplot2PlotOrchestrator-process_patchwork_plot}{\code{Ggplot2PlotOrchestrator$process_patchwork_plot()}}
\item \href{#method-Ggplot2PlotOrchestrator-has_unsupported_layers}{\code{Ggplot2PlotOrchestrator$has_unsupported_layers()}}
\item \href{#method-Ggplot2PlotOrchestrator-should_fallback}{\code{Ggplot2PlotOrchestrator$should_fallback()}}
\item \href{#method-Ggplot2PlotOrchestrator-clone}{\code{Ggplot2PlotOrchestrator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-new"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$new(plot)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-detect_layers"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-detect_layers}{}}}
\subsection{Method \code{detect_layers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$detect_layers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-analyze_single_layer"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-analyze_single_layer}{}}}
\subsection{Method \code{analyze_single_layer()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$analyze_single_layer(layer, layer_index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-determine_layer_type"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-determine_layer_type}{}}}
\subsection{Method \code{determine_layer_type()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$determine_layer_type(plot, layer_index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-create_layer_processors"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-create_layer_processors}{}}}
\subsection{Method \code{create_layer_processors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$create_layer_processors()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-create_layer_processor"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-create_layer_processor}{}}}
\subsection{Method \code{create_layer_processor()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$create_layer_processor(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-create_unified_layer_processor"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-create_unified_layer_processor}{}}}
\subsection{Method \code{create_unified_layer_processor()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$create_unified_layer_processor(layer_info)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer_info}}{Layer information}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Layer processor instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-process_layers"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-process_layers}{}}}
\subsection{Method \code{process_layers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$process_layers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-extract_layout"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-extract_layout}{}}}
\subsection{Method \code{extract_layout()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$extract_layout()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-combine_layer_results"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-combine_layer_results}{}}}
\subsection{Method \code{combine_layer_results()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$combine_layer_results(layer_results)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-generate_maidr_data"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-generate_maidr_data}{}}}
\subsection{Method \code{generate_maidr_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$generate_maidr_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-get_gtable"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-get_gtable}{}}}
\subsection{Method \code{get_gtable()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$get_gtable()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-get_layout"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-get_layout}{}}}
\subsection{Method \code{get_layout()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$get_layout()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-get_combined_data"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-get_combined_data}{}}}
\subsection{Method \code{get_combined_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$get_combined_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-get_layer_processors"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-get_layer_processors}{}}}
\subsection{Method \code{get_layer_processors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$get_layer_processors()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-get_layers"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-get_layers}{}}}
\subsection{Method \code{get_layers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$get_layers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-is_patchwork_plot"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-is_patchwork_plot}{}}}
\subsection{Method \code{is_patchwork_plot()}}{
Check if the plot is a patchwork composition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$is_patchwork_plot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical indicating if the plot is a patchwork plot
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-is_faceted_plot"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-is_faceted_plot}{}}}
\subsection{Method \code{is_faceted_plot()}}{
Check if the plot is faceted
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$is_faceted_plot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical indicating if the plot is faceted
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-process_faceted_plot"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-process_faceted_plot}{}}}
\subsection{Method \code{process_faceted_plot()}}{
Process a faceted plot using utility functions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$process_faceted_plot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL (sets internal state)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-process_patchwork_plot"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-process_patchwork_plot}{}}}
\subsection{Method \code{process_patchwork_plot()}}{
Process a patchwork multipanel plot using utility functions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$process_patchwork_plot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL (sets internal state)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-has_unsupported_layers"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-has_unsupported_layers}{}}}
\subsection{Method \code{has_unsupported_layers()}}{
Check if any layers are unsupported (unknown type)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$has_unsupported_layers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical indicating if there are unsupported layers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-should_fallback"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-should_fallback}{}}}
\subsection{Method \code{should_fallback()}}{
Determine if the plot should fall back to image rendering
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$should_fallback()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical indicating if fallback should be used
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2PlotOrchestrator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2PlotOrchestrator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2PlotOrchestrator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
