% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmap-text.R
\name{bitmap_text_coords}
\alias{bitmap_text_coords}
\title{Create a data.frame of pixel coordinate information of the rendered text}
\usage{
bitmap_text_coords(text, font = "unifont", dx = 0L, dy = 0L, missing = NULL)
}
\arguments{
\item{text}{Single text string. Can include carriage returns to split text 
over multiple lines.}

\item{font}{Name of bitmap font, or a 'lofi' font object.  Default: 'unifont'.
Use \code{get_lofi_names('bitmap')} to retrieve a list of all valid
bitmap fonts included in this package.  To create a 'lofi' font object
use \code{\link{convert_bm_font_to_lofi}()}}

\item{dx}{Additional character spacing in the horizontal direction. Default: 0}

\item{dy}{Additional character spacing in the vertical direction i.e. between 
rows of text. Default: 0}

\item{missing}{Codepoint to use if glyph not found in font. 
Default: NULL means to use the default specified by the font internally.
Otherwise it will default to the codepoint for '?'}
}
\value{
data.frame of coordinate information
\describe{
  \item{\code{char_idx}}{The index of the glyph within the provided \code{text} string}
  \item{\code{codepoint}}{Unicode codepoint (integer)}
  \item{\code{x}}{Pixel coordinate x value for display}
  \item{\code{y}}{Pixel coordinate y value for display}
  \item{\code{line}}{Line number within input \code{text} where this character appears}
  \item{\code{x0}}{Original untransformed x-coordinate}
  \item{\code{y0}}{Original untransformed y-coordinate}
}
}
\description{
Create a data.frame of pixel coordinate information of the rendered text
}
\examples{
bitmap_text_coords('Hi')
}
\seealso{
Other bitmap text functions: 
\code{\link{bitmap_text_matrix}()},
\code{\link{bitmap_text_raster}()}
}
\concept{bitmap text functions}
