% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{interaction_st_fast}
\alias{interaction_st_fast}
\title{Fast spatio-temporal interaction for the self-correcting model}
\usage{
interaction_st_fast(data, params)
}
\arguments{
\item{data}{NumericMatrix with columns (time, x, y). Assumed sorted by time ascending.}

\item{params}{NumericVector length 3: (alpha3, beta3, gamma3)}
}
\value{
NumericVector length n of exp(-alpha3 * counts)
}
\description{
Computes $g_i = exp(-alpha3 * sum_\{j<i\} 1[ ||x_i-x_j|| <= beta3 AND (t_i - t_j) >= gamma3 ])$
for i = 1..n, with g_0 = exp(0) = 1.
}
\keyword{internal}
