% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_model_fit.R
\name{check_model_fit}
\alias{check_model_fit}
\title{Check the fit of an estimated model using global envelope tests}
\usage{
check_model_fit(
  reference_data = NULL,
  t_min = 0,
  t_max = 1,
  process = c("self_correcting"),
  process_fit = NULL,
  anchor_point = NULL,
  raster_list = NULL,
  scaled_rasters = FALSE,
  mark_model = NULL,
  xy_bounds = NULL,
  include_comp_inds = FALSE,
  thinning = TRUE,
  edge_correction = "none",
  competition_radius = 15,
  n_sim = 2500,
  save_sims = TRUE,
  verbose = TRUE,
  seed = 0,
  parallel = FALSE,
  num_cores = max(1L, parallel::detectCores() - 1L),
  set_future_plan = FALSE,
  mark_mode = NULL,
  fg_correction = c("km", "rs"),
  max_attempts = NULL
)
}
\arguments{
\item{reference_data}{(optional) a marked \code{ppp} object for the reference dataset.
If \code{NULL}, the reference pattern is derived from \code{process_fit} when
\code{process_fit} is an \code{ldmppr_fit} and contains \code{data_original}
(preferred) or \code{data} with columns \code{(x,y,size)}.}

\item{t_min}{minimum value for time.}

\item{t_max}{maximum value for time.}

\item{process}{type of process used (currently supports \code{"self_correcting"}).}

\item{process_fit}{either an \code{ldmppr_fit} object (from \code{estimate_process_parameters})
or a numeric vector of length 8 giving the process parameters.}

\item{anchor_point}{(optional) vector of (x,y) coordinates of the point to condition on.
If \code{NULL}, inferred from the reference data (largest mark if available) or from
\code{ldmppr_fit}.}

\item{raster_list}{(optional) list of raster objects used for mark prediction.
Required when \code{mark_mode='mark_model'} unless rasters are stored in \code{mark_model}.}

\item{scaled_rasters}{\code{TRUE} or \code{FALSE} indicating whether rasters are already scaled.
Ignored when \code{mark_mode='time_to_size'}.}

\item{mark_model}{a mark model object used when \code{mark_mode='mark_model'}.
May be an \code{ldmppr_mark_model}, \code{model_fit}, or \code{workflow}.}

\item{xy_bounds}{(optional) vector of bounds as \code{c(a_x, b_x, a_y, b_y)}. If \code{NULL}, will be
inferred from \code{reference_data}'s window when \code{reference_data} is provided,
otherwise from \code{ldmppr_fit} with lower bounds assumed to be 0.}

\item{include_comp_inds}{\code{TRUE} or \code{FALSE} indicating whether to compute competition indices.}

\item{thinning}{\code{TRUE} or \code{FALSE} indicating whether to use the thinned simulated values.}

\item{edge_correction}{type of edge correction to apply (\code{"none"} or \code{"toroidal"}).}

\item{competition_radius}{positive numeric distance used when \code{include_comp_inds = TRUE}.}

\item{n_sim}{number of simulated datasets to generate.}

\item{save_sims}{\code{TRUE} or \code{FALSE} indicating whether to save and return the simulated metrics.}

\item{verbose}{\code{TRUE} or \code{FALSE} indicating whether to show progress of model checking.
When \code{TRUE}, progress is reported via \pkg{progressr} (if available) and is compatible with parallel execution.}

\item{seed}{integer seed for reproducibility.}

\item{parallel}{\code{TRUE} or \code{FALSE}. If \code{TRUE}, simulations run in parallel via \pkg{furrr}/\pkg{future}.
For small simulation sizes, parallel overhead may outweigh speed gains.}

\item{num_cores}{number of workers to use when \code{parallel=TRUE}. Defaults to one fewer than detected cores.}

\item{set_future_plan}{\code{TRUE} or \code{FALSE}. If \code{TRUE} and \code{parallel=TRUE},
set a temporary \pkg{future} plan internally and restore the previous plan on exit.}

\item{mark_mode}{(optional) mark generation mode: \code{"mark_model"} uses
\code{predict()} on a mark model, while \code{"time_to_size"} maps simulated
times back to sizes via \code{delta}. If \code{NULL}, inferred as
\code{"mark_model"} when \code{mark_model} is provided, otherwise
\code{"time_to_size"}.}

\item{fg_correction}{correction used for F/G/J summaries (\code{"km"} or \code{"rs"}).}

\item{max_attempts}{maximum number of simulation attempts when rejection occurs
due to non-finite summaries.}
}
\value{
an object of class \code{"ldmppr_model_check"}.
}
\description{
Performs global envelope tests for nonparametric L, F, G, J, E, and V summary
functions (\code{\link[spatstat:spatstat]{spatstat}}/\code{\link[GET:GET]{GET}}).
These tests assess goodness-of-fit of the estimated model relative to a reference marked point pattern.
The reference marked point pattern can be supplied directly via \code{reference_data} (a marked \code{ppp} object),
or derived internally from a \code{ldmppr_fit} object.
}
\details{
This function relies on the \code{\link[spatstat:spatstat]{spatstat}} package for the calculation of the point pattern metrics
and the \code{\link[GET:GET]{GET}} package for the global envelope tests. The L, F, G, J, E, and V functions are a collection of
non-parametric summary statistics that describe the spatial distribution of points and marks in a point pattern.
See the documentation for \code{\link[spatstat.explore:Lest]{Lest()}}, \code{\link[spatstat.explore:Fest]{Fest()}}, \code{\link[spatstat.explore:Gest]{Gest()}},
\code{\link[spatstat.explore:Jest]{Jest()}}, \code{\link[spatstat.explore:Emark]{Emark()}}, and \code{\link[spatstat.explore:Vmark]{Vmark()}} for more information.
Also, see the \code{\link[GET:global_envelope_test]{global_envelope_test()}} function for more information on the global envelope tests.
}
\examples{
# Note: The example below is provided for illustrative purposes and may take some time to run.
\donttest{
data(small_example_data)

file_path <- system.file("extdata", "example_mark_model.rds", package = "ldmppr")
mark_model <- load_mark_model(file_path)

raster_paths <- list.files(system.file("extdata", package = "ldmppr"),
                           pattern = "\\\\.tif$", full.names = TRUE)
raster_paths <- raster_paths[!grepl("_med\\\\.tif$", raster_paths)]
rasters <- lapply(raster_paths, terra::rast)
scaled_raster_list <- scale_rasters(rasters)

reference_data <- generate_mpp(
  locations = small_example_data[, c("x", "y")],
  marks = small_example_data$size,
  xy_bounds = c(0, 25, 0, 25)
)

estimated_parameters <- c(
  0.05167978, 8.20702166, 0.02199940, 2.63236890,
  1.82729512, 0.65330061, 0.86666748, 0.04681878
)

# Keep parallel=FALSE in examples to avoid setup overhead.
example_model_fit <- check_model_fit(
  reference_data = reference_data,
  t_min = 0,
  t_max = 1,
  process = "self_correcting",
  process_fit = estimated_parameters,
  raster_list = scaled_raster_list,
  scaled_rasters = TRUE,
  mark_model = mark_model,
  xy_bounds = c(0, 25, 0, 25),
  include_comp_inds = TRUE,
  thinning = TRUE,
  edge_correction = "none",
  competition_radius = 10,
  n_sim = 100,
  save_sims = FALSE,
  verbose = TRUE,
  seed = 90210,
  parallel = FALSE
)

plot(example_model_fit, which = 'combined')
}
}
\references{
Baddeley, A., Rubak, E., & Turner, R. (2015). *Spatial Point Patterns:
Methodology and Applications with R*. Chapman and Hall/CRC Press, London.
ISBN 9781482210200. Available at:
\url{https://www.routledge.com/Spatial-Point-Patterns-Methodology-and-Applications-with-R/Baddeley-Rubak-Turner/p/book/9781482210200}.

Myllymäki, M., & Mrkvička, T. (2023). GET: Global envelopes in R.
\emph{arXiv:1911.06583 [stat.ME]}. \doi{10.48550/arXiv.1911.06583}.
}
