% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_helpers.R, R/predict_marks.R
\name{ldmppr-internal}
\alias{ldmppr-internal}
\alias{new_ldmppr_model_check}
\alias{new_ldmppr_sim}
\alias{new_ldmppr_mark_model}
\alias{new_ldmppr_fit}
\alias{preprocess_new_data}
\alias{rehydrate_xgb}
\alias{as_mark_model}
\alias{.build_sc_matrix}
\alias{.default_sc_param_bounds}
\alias{\%||\%}
\alias{.require_pkgs}
\alias{.coerce_training_df}
\alias{infer_xy_bounds_from_ppp}
\alias{infer_anchor_from_ppp}
\alias{infer_anchor_from_df}
\alias{resolve_sc_params}
\alias{resolve_reference_ppp}
\alias{.as_sc_params}
\alias{.infer_xy_bounds}
\alias{.infer_anchor_point}
\alias{new_ldmppr_budgets}
\alias{is_ldmppr_budgets}
\alias{as_ldmppr_budgets}
\alias{.validate_ldmppr_budgets}
\alias{new_ldmppr_grids}
\alias{is_ldmppr_grids}
\alias{as_ldmppr_grids}
\alias{.validate_ldmppr_grids}
\alias{.ldmppr_make_grid_schedule}
\alias{infer_rasters_from_mark_model}
\alias{infer_scaled_flag_from_mark_model}
\alias{.apply_resid_bootstrap}
\alias{.inv_transform}
\alias{.inv_powerlaw_time_to_size}
\alias{.build_mark_predictors}
\alias{.predict_marks_legacy}
\title{Internal helpers (not part of the public API)}
\usage{
new_ldmppr_model_check(
  combined_env,
  envs,
  curve_sets,
  sim_metrics = NULL,
  settings = list(),
  call = NULL
)

new_ldmppr_sim(
  process,
  mpp,
  realization,
  params,
  bounds,
  anchor_point,
  thinning,
  edge_correction,
  include_comp_inds,
  competition_radius,
  call = NULL,
  meta = list()
)

new_ldmppr_mark_model(
  engine,
  fit_engine = NULL,
  xgb_raw = NULL,
  recipe = NULL,
  outcome = "size",
  feature_names = NULL,
  rasters = NULL,
  info = list()
)

new_ldmppr_fit(
  process,
  fit,
  fits = NULL,
  mapping = NULL,
  settings = NULL,
  grid = NULL,
  data_summary = NULL,
  data = NULL,
  data_original = NULL,
  engine = "nloptr",
  call = NULL,
  timing = NULL
)

preprocess_new_data(object, new_data)

rehydrate_xgb(object)

as_mark_model(mark_model)

.build_sc_matrix(data, delta = NULL)

.default_sc_param_bounds(txy, upper_bounds)

a \%||\% b

.require_pkgs(pkgs)

.coerce_training_df(x, delta = NULL, xy_bounds = NULL)

infer_xy_bounds_from_ppp(ppp)

infer_anchor_from_ppp(ppp)

infer_anchor_from_df(df)

resolve_sc_params(process_fit)

resolve_reference_ppp(reference_data, process_fit, xy_bounds)

.as_sc_params(process_fit)

.infer_xy_bounds(process_fit)

.infer_anchor_point(process_fit)

new_ldmppr_budgets(
  global_options,
  local_budget_first_level,
  local_budget_refinement_levels = NULL
)

is_ldmppr_budgets(x)

as_ldmppr_budgets(x, ...)

.validate_ldmppr_budgets(b)

new_ldmppr_grids(levels, upper_bounds, labels = NULL, include_endpoints = TRUE)

is_ldmppr_grids(x)

as_ldmppr_grids(x, ...)

.validate_ldmppr_grids(g)

.ldmppr_make_grid_schedule(
  upper_bounds,
  levels,
  labels = NULL,
  include_endpoints = TRUE
)

infer_rasters_from_mark_model(mm)

infer_scaled_flag_from_mark_model(mm)

.apply_resid_bootstrap(mu, rb)

.inv_transform(z, transform)

.inv_powerlaw_time_to_size(t, smin, smax, delta)

.build_mark_predictors(
  sim_realization,
  raster_list,
  scaled_rasters,
  xy_bounds,
  include_comp_inds,
  competition_radius,
  edge_correction
)

.predict_marks_legacy(
  sim_realization,
  raster_list,
  scaled_rasters,
  mark_model,
  xy_bounds,
  include_comp_inds,
  competition_radius,
  edge_correction,
  seed = NULL
)
}
\description{
These functions are used internally by ldmppr and are not intended to be
called directly by users.
}
\keyword{internal}
