% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnn_kindling.R
\name{rnn_kindling}
\alias{rnn_kindling}
\title{Recurrent Neural Network via kindling}
\usage{
rnn_kindling(
  mode = "unknown",
  engine = "kindling",
  hidden_neurons = NULL,
  activations = NULL,
  output_activation = NULL,
  bias = NULL,
  bidirectional = NULL,
  dropout = NULL,
  epochs = NULL,
  batch_size = NULL,
  penalty = NULL,
  mixture = NULL,
  learn_rate = NULL,
  optimizer = NULL,
  validation_split = NULL,
  rnn_type = NULL,
  optimizer_args = NULL,
  loss = NULL,
  early_stopping = NULL,
  device = NULL,
  verbose = NULL,
  cache_weights = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model. Possible values
are "unknown", "regression", or "classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Currently only "kindling" is supported.}

\item{hidden_neurons}{An integer vector for the number of units in each hidden
layer. Can be tuned.}

\item{activations}{A character vector of activation function names for each
hidden layer (e.g., "relu", "tanh", "sigmoid"). Can be tuned.}

\item{output_activation}{A character string for the output activation function.
Can be tuned.}

\item{bias}{Logical for whether to include bias terms. Can be tuned.}

\item{bidirectional}{A logical indicating whether to use bidirectional RNN.
Can be tuned.}

\item{dropout}{A number between 0 and 1 for dropout rate between layers.
Can be tuned.}

\item{epochs}{An integer for the number of training iterations. Can be tuned.}

\item{batch_size}{An integer for the batch size during training. Can be tuned.}

\item{penalty}{A number for the regularization penalty (lambda). Default \code{0}
(no regularization). Higher values increase regularization strength. Can be tuned.}

\item{mixture}{A number between 0 and 1 for the elastic net mixing parameter.
Default \code{0} (pure L2/Ridge regularization).
\itemize{
\item \code{0}: Pure L2 regularization (Ridge)
\item \code{1}: Pure L1 regularization (Lasso)
\item \verb{0 < mixture < 1}: Elastic net (combination of L1 and L2)
Only relevant when \code{penalty > 0}. Can be tuned.
}}

\item{learn_rate}{A number for the learning rate. Can be tuned.}

\item{optimizer}{A character string for the optimizer type ("adam", "sgd",
"rmsprop"). Can be tuned.}

\item{validation_split}{A number between 0 and 1 for the proportion of data
used for validation. Can be tuned.}

\item{rnn_type}{A character string for the type of RNN cell ("rnn", "lstm",
"gru"). Cannot be tuned — pass via \code{set_engine()}.}

\item{optimizer_args}{A named list of additional arguments passed to the
optimizer. Cannot be tuned — pass via \code{set_engine()}.}

\item{loss}{A character string for the loss function ("mse", "mae",
"cross_entropy", "bce"). Cannot be tuned — pass via \code{set_engine()}.}

\item{early_stopping}{An \code{\link[=early_stop]{early_stop()}} object or \code{NULL}. Cannot be tuned —
pass via \code{set_engine()}.}

\item{device}{A character string for the device ("cpu", "cuda", "mps").
Cannot be tuned — pass via \code{set_engine()}.}

\item{verbose}{Logical for whether to print training progress. Cannot be
tuned — pass via \code{set_engine()}.}

\item{cache_weights}{Logical. If \code{TRUE}, stores trained weight matrices in
the returned object. Cannot be tuned — pass via \code{set_engine()}.}
}
\value{
A model specification object with class \code{rnn_kindling}.
}
\description{
\code{rnn_kindling()} defines a recurrent neural network model that can be used
for classification or regression on sequential data. It integrates with the
tidymodels ecosystem and uses the torch backend via kindling.
}
\details{
This function creates a model specification for a recurrent neural network
that can be used within tidymodels workflows. The model supports:
\itemize{
\item Multiple RNN types: basic RNN, LSTM, and GRU
\item Bidirectional processing
\item Dropout regularization
\item GPU acceleration (CUDA, MPS, or CPU)
\item Hyperparameter tuning integration
\item Both regression and classification tasks
}

The \code{device} parameter controls where computation occurs:
\itemize{
\item \code{NULL} (default): Auto-detect best available device (CUDA > MPS > CPU)
\item \code{"cuda"}: Use NVIDIA GPU
\item \code{"mps"}: Use Apple Silicon GPU
\item \code{"cpu"}: Use CPU only
}
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
    box::use(
        recipes[recipe],
        workflows[workflow, add_recipe, add_model],
        parsnip[fit]
    )

    # Model specs
    rnn_spec = rnn_kindling(
        mode = "classification",
        hidden_neurons = c(64, 32),
        rnn_type = "lstm",
        activation = c("relu", "elu"),
        epochs = 100,
        bidirectional = TRUE
    )

    wf = workflow() |>
        add_recipe(recipe(Species ~ ., data = iris)) |>
        add_model(rnn_spec)

    fit_wf = fit(wf, data = iris)
    fit_wf
} else {
    message("Torch not fully installed — skipping example")
}
}

}
