% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp.R, R/rnn.R
\name{predict-basemodel}
\alias{predict-basemodel}
\alias{predict.ffnn_fit}
\alias{predict.rnn_fit}
\title{Predict method for kindling basemodel fits}
\usage{
\method{predict}{ffnn_fit}(object, newdata = NULL, new_data = NULL, type = "response", ...)

\method{predict}{rnn_fit}(object, newdata = NULL, new_data = NULL, type = "response", ...)
}
\arguments{
\item{object}{An object of class \code{"ffnn_fit"} or \code{"rnn_fit"}.}

\item{newdata}{Data frame. New data for predictions. If \code{NULL}, uses the
original training data (if available).}

\item{new_data}{Alternative to newdata (for consistency with hardhat).}

\item{type}{Character. Type of prediction:
\itemize{
\item \code{"response"} (default) – predicted values or predicted classes
\item \code{"prob"} – class probabilities (only for classification models)
}}

\item{...}{Currently unused.}
}
\value{
\itemize{
\item For \strong{regression} models: a numeric vector (single output) or matrix
(multiple outputs) of predicted values.
\item For \strong{classification} models:
\itemize{
\item \code{type = "response"}: a factor vector of predicted class labels
\item \code{type = "prob"}: a numeric matrix of class probabilities, with columns
named after the class levels.
}
}
}
\description{
Predict method for kindling basemodel fits
}
\keyword{internal}
