% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/act-funnew.R
\name{new_act_fn}
\alias{new_act_fn}
\title{Custom Activation Function Constructor}
\usage{
new_act_fn(fn, probe = TRUE, .name = "<custom>")
}
\arguments{
\item{fn}{A function taking a single tensor argument and returning a tensor.
E.g. \verb{\\(x) torch::torch_tanh(x)}.}

\item{probe}{Logical. If \code{TRUE} (default), runs a dry-run with a small
dummy tensor at definition time to catch obvious errors early.}

\item{.name}{A string to be stored in an attribute. Nothing special, except it is
used when displaying the info of a trained neural network model.
Default is \code{"<custom>"}.}
}
\value{
An object of class \code{c("custom_activation", "parameterized_activation")},
compatible with \code{act_funs()}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Wraps a user-supplied function into a validated custom activation,
ensuring it accepts and returns a \code{torch_tensor}. Performs an eager
dry-run probe at \emph{definition time} so errors surface early, and
wraps the function with a \emph{call-time} type guard for safety.
}
\examples{
\dontrun{
\donttest{
act_funs(relu, elu, new_act_fn(\(x) torch::torch_tanh(x)))
act_funs(new_act_fn(\(x) torch::nnf_silu(x)))
}
}

}
