% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/torch-code-gen.R
\docType{data}
\name{layer_prs}
\alias{layer_prs}
\alias{.layer}
\alias{.i}
\alias{.in}
\alias{.out}
\alias{.is_output}
\title{Layer argument pronouns for formula-based specifications}
\format{
An object of class \code{layer_pr} (inherits from \code{list}) of length 0.

An object of class \code{layer_index_pr} (inherits from \code{layer_pr}, \code{list}) of length 0.

An object of class \code{layer_input_pr} (inherits from \code{layer_pr}, \code{list}) of length 0.

An object of class \code{layer_output_pr} (inherits from \code{layer_pr}, \code{list}) of length 0.

An object of class \code{layer_is_output_pr} (inherits from \code{layer_pr}, \code{list}) of length 0.
}
\usage{
.layer

.i

.in

.out

.is_output
}
\description{
These pronouns provide a cleaner, more readable way to reference layer parameters
in formula-based specifications for \code{nn_module_generator()} and related functions.
They work similarly to \code{rlang::.data} and \code{rlang::.env}.
}
\details{
Available pronouns:
\itemize{
\item \code{.layer}: Access all layer parameters as a list-like object
\item \code{.i}: Layer index (1-based integer)
\item \code{.in}: Input dimension for the layer
\item \code{.out}: Output dimension for the layer
\item \code{.is_output}: Logical indicating if this is the output layer
}

These pronouns can be used in formulas passed to:
\itemize{
\item \code{layer_arg_fn} parameter
\item Custom layer configuration functions
}
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Using individual pronouns
layer_arg_fn = ~ list(
    input_size = .in,
    hidden_size = .out,
    num_layers = if (.i == 1) 2L else 1L
)

# Using .layer pronoun (alternative syntax)
layer_arg_fn = ~ list(
    input_size = .layer$ind,
    hidden_size = .layer$out,
    is_first = .layer$i == 1
)
}\if{html}{\out{</div>}}
}

\keyword{datasets}
