% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-train-nn-parsnip.R, R/mlp_kindling.R,
%   R/rnn_kindling.R
\name{train_nn_wrapper}
\alias{train_nn_wrapper}
\alias{ffnn_wrapper}
\alias{rnn_wrapper}
\title{kindling-tidymodels wrapper}
\usage{
train_nn_wrapper(formula, data, ...)

ffnn_wrapper(formula, data, ...)

rnn_wrapper(formula, data, ...)
}
\arguments{
\item{formula}{A formula specifying the model (e.g., \code{y ~ x1 + x2})}

\item{data}{A data frame containing the training data}

\item{...}{Additional arguments passed to the underlying training function}
}
\value{
\code{train_nn_wrapper()} returns an \code{"nn_fit_tab"} object. See \code{\link[=train_nn]{train_nn()}} for details.

\itemize{
\item \code{ffnn_wrapper()} returns an object of class \code{"ffnn_fit"} containing the trained feedforward neural network model and metadata. See \code{\link[=ffnn]{ffnn()}} for details.
\item \code{rnn_wrapper()} returns an object of class \code{"rnn_fit"} containing the trained recurrent neural network model and metadata. See \code{\link[=rnn]{rnn()}} for details.
}
}
\description{
kindling-tidymodels wrapper

Basemodels-tidymodels wrappers
}
\details{
This wrapper function is designed to interface with the \code{{tidymodels}}
ecosystem, particularly for use with \code{\link[tune:tune_grid]{tune::tune_grid()}} and workflows.
It handles the conversion of tuning parameters (especially list-column
parameters from \code{\link[=grid_depth]{grid_depth()}}) into the format expected by \code{\link[=train_nn]{train_nn()}}.

These wrapper functions are designed to interface with the \code{{tidymodels}}
ecosystem, particularly for use with \code{\link[tune:tune_grid]{tune::tune_grid()}} and workflows.
They handle the conversion of tuning parameters (especially list-column
parameters from \code{\link[=grid_depth]{grid_depth()}}) into the format expected by \code{\link[=ffnn]{ffnn()}} and \code{\link[=rnn]{rnn()}}.
}
\section{MLP Wrapper for \code{{tidymodels}} interface}{

Internal wrapper — use \code{mlp_kindling()} + \code{fit()} instead.
}

\section{FFNN (MLP) Wrapper for \code{{tidymodels}} interface}{

This is a function to interface into \code{{tidymodels}}
(do not use this, use \code{kindling::ffnn()} instead).
}

\section{RNN Wrapper for \code{{tidymodels}} interface}{

Internal wrapper — use \code{rnn_kindling()} + \code{fit()} instead.
}

\keyword{internal}
