% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp.R, R/rnn.R
\name{kindling-basemodels}
\alias{kindling-basemodels}
\alias{ffnn}
\alias{rnn}
\title{Base models for Neural Network Training in kindling}
\usage{
ffnn(
  formula = NULL,
  data = NULL,
  hidden_neurons,
  activations = NULL,
  output_activation = NULL,
  bias = TRUE,
  epochs = 100,
  batch_size = 32,
  penalty = 0,
  mixture = 0,
  learn_rate = 0.001,
  optimizer = "adam",
  optimizer_args = list(),
  loss = "mse",
  validation_split = 0,
  device = NULL,
  verbose = FALSE,
  cache_weights = FALSE,
  ...,
  x = NULL,
  y = NULL
)

rnn(
  formula = NULL,
  data = NULL,
  hidden_neurons,
  rnn_type = "lstm",
  activations = NULL,
  output_activation = NULL,
  bias = TRUE,
  bidirectional = TRUE,
  dropout = 0,
  epochs = 100,
  batch_size = 32,
  penalty = 0,
  mixture = 0,
  learn_rate = 0.001,
  optimizer = "adam",
  optimizer_args = list(),
  loss = "mse",
  validation_split = 0,
  device = NULL,
  verbose = FALSE,
  cache_weights = FALSE,
  ...,
  x = NULL,
  y = NULL
)
}
\arguments{
\item{formula}{Formula. Model formula (e.g., y ~ x1 + x2).}

\item{data}{Data frame. Training data.}

\item{hidden_neurons}{Integer vector. Number of neurons in each hidden layer.}

\item{activations}{Activation function specifications. See \code{act_funs()}.}

\item{output_activation}{Optional. Activation for output layer.}

\item{bias}{Logical. Use bias weights. Default \code{TRUE}.}

\item{epochs}{Integer. Number of training epochs. Default \code{100}.}

\item{batch_size}{Integer. Batch size for training. Default \code{32}.}

\item{penalty}{Numeric. Regularization penalty (lambda). Default \code{0} (no regularization).}

\item{mixture}{Numeric. Elastic net mixing parameter (0-1). Default \code{0}.}

\item{learn_rate}{Numeric. Learning rate for optimizer. Default \code{0.001}.}

\item{optimizer}{Character. Optimizer type ("adam", "sgd", "rmsprop"). Default \code{"adam"}.}

\item{optimizer_args}{Named list. Additional arguments passed to the optimizer. Default \code{list()}.}

\item{loss}{Character. Loss function ("mse", "mae", "cross_entropy", "bce"). Default \code{"mse"}.}

\item{validation_split}{Numeric. Proportion of data for validation (0-1). Default \code{0}.}

\item{device}{Character. Device to use ("cpu", "cuda", "mps"). Default \code{NULL} (auto-detect).}

\item{verbose}{Logical. Print training progress. Default \code{FALSE}.}

\item{cache_weights}{Logical. Cache weight matrices for faster variable importance. Default \code{FALSE}.}

\item{...}{Additional arguments. Can be used to pass \code{x} and \code{y} for direct interface.}

\item{x}{When not using formula: predictor data (data.frame or matrix).}

\item{y}{When not using formula: outcome data (vector, factor, or matrix).}

\item{rnn_type}{Character. Type of RNN ("rnn", "lstm", "gru"). Default \code{"lstm"}.}

\item{bidirectional}{Logical. Use bidirectional RNN. Default \code{TRUE}.}

\item{dropout}{Numeric. Dropout rate between layers. Default \code{0}.}
}
\value{
An object of class "ffnn_fit" containing the trained model and metadata.
}
\description{
Base models for Neural Network Training in kindling
}
\section{FFNN}{

Train a feed-forward neural network using the torch package.
}

\section{RNN}{

Train a recurrent neural network using the torch package.
}

\examples{
\donttest{
if (torch::torch_is_installed()) {
    # Formula interface (original)
    model_reg = ffnn(
        Sepal.Length ~ .,
        data = iris[, 1:4],
        hidden_neurons = c(64, 32),
        activations = "relu",
        epochs = 50
    )

    # XY interface (new)
    model_xy = ffnn(
        hidden_neurons = c(64, 32),
        activations = "relu",
        epochs = 50,
        x = iris[, 2:4],
        y = iris$Sepal.Length
    )
}
}

\donttest{
if (torch::torch_is_installed()) {
    # Formula interface (original)
    model_rnn = rnn(
        Sepal.Length ~ .,
        data = iris[, 1:4],
        hidden_neurons = c(64, 32),
        rnn_type = "lstm",
        activations = "relu",
        epochs = 50
    )

    # XY interface (new)
    model_xy = rnn(
        hidden_neurons = c(64, 32),
        rnn_type = "gru",
        epochs = 50,
        x = iris[, 2:4],
        y = iris$Sepal.Length
    )
}
}

}
