% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalized-nn-fit.R, R/generalized-nn-fitds.R
\name{gen-nn-predict}
\alias{gen-nn-predict}
\alias{predict.nn_fit}
\alias{predict.nn_fit_tab}
\alias{predict.nn_fit_ds}
\title{Predict from a trained neural network}
\usage{
\method{predict}{nn_fit}(object, newdata = NULL, new_data = NULL, type = "response", ...)

\method{predict}{nn_fit_tab}(object, newdata = NULL, new_data = NULL, type = "response", ...)

\method{predict}{nn_fit_ds}(object, newdata = NULL, new_data = NULL, type = "response", ...)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link[=train_nn]{train_nn()}}.}

\item{newdata}{New predictor data. Accepted forms depend on the method:
\itemize{
\item \code{predict.nn_fit()}: a numeric \code{matrix} or coercible object.
\item \code{predict.nn_fit_tab()}: a \code{data.frame} with the same columns used during
training; preprocessing is applied automatically via \code{hardhat::forge()}.
\item \code{predict.nn_fit_ds()}: a \code{torch} \code{dataset}, numeric \code{array}, \code{matrix}, or
\code{data.frame}.
If \code{NULL}, the cached fitted values from training are returned (not
available for \code{type = "prob"}).
}}

\item{new_data}{Legacy alias for \code{newdata}. Retained for compatibility.}

\item{type}{Character. Output type:
\itemize{
\item \code{"response"} (default): predicted class labels (factor) for
classification, or a numeric vector / matrix for regression.
\item \code{"prob"}: a numeric matrix of class probabilities (classification only).
}}

\item{...}{Currently unused; reserved for future extensions.}
}
\value{
\itemize{
\item \strong{Regression}: a numeric vector (single output) or matrix (multiple outputs).
\item \strong{Classification}, \code{type = "response"}: a factor with levels matching those
seen during training.
\item \strong{Classification}, \code{type = "prob"}: a numeric matrix with one column per
class, columns named by class label.
}
}
\description{
Generate predictions from an \code{"nn_fit"} object produced by \code{\link[=train_nn]{train_nn()}}.

Three S3 methods are registered:
\itemize{
\item \code{predict.nn_fit()} — base method for \code{matrix}-trained models.
\item \code{predict.nn_fit_tab()} — extends the base method for tabular fits; runs new
data through \code{hardhat::forge()} before predicting.
\item \code{predict.nn_fit_ds()} — extends the base method for torch \code{dataset} fits.
}
}
\seealso{
\code{\link[=train_nn]{train_nn()}}
}
\keyword{internal}
