% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/act-fun.R
\name{act_funs}
\alias{act_funs}
\title{Activation Functions Specification Helper}
\usage{
act_funs(...)
}
\arguments{
\item{...}{Activation function specifications. Can be:
\itemize{
\item Bare symbols: \code{relu}, \code{tanh}
\item Character strings (simple): \code{"relu"}, \code{"tanh"}
\item Character strings (with params): \code{"softshrink(lambda = 0.1)"}, \code{"rrelu(lower = 1/5, upper = 1/4)"}
\item Named with parameters: \code{softmax = args(dim = 2L)}
\item Indexed syntax (named): \code{softshrink[lambd = 0.2]}, \code{rrelu[lower = 1/5, upper = 1/4]}
\item Indexed syntax (unnamed): \code{softshrink[0.5]}, \code{elu[0.5]}
}}
}
\value{
A \code{vctrs} vector with class "activation_spec" containing validated
activation specifications.
}
\description{
This function is a DSL function, kind of like \code{ggplot2::aes()}, that helps to
specify activation functions for neural network layers. It validates that
activation functions exist in \code{torch} and that any parameters match the
function's formal arguments.
}
