% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-id.R
\name{check_id}
\alias{check_id}
\title{Check ID integrity}
\usage{
check_id(.data, .id = ".id")
}
\arguments{
\item{.data}{A data frame with ID column.}

\item{.id}{Column name (default: ".id").}
}
\value{
Invisibly returns a list with:
\itemize{
\item \code{valid}: TRUE if no issues found
\item \code{n_na}: count of NA values
\item \code{n_duplicates}: count of duplicate IDs
\item \code{format_ok}: TRUE if IDs look like proper UUIDs/hashes
}
}
\description{
Validates ID column for common issues: missing values, duplicates,
and suspicious formats.
}
\examples{
df <- add_id(data.frame(x = 1:3))
check_id(df)

}
