% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{getw}
\alias{getw}
\title{Find Weights using Entropy Balancing.}
\usage{
getw(
  target,
  observed,
  svd.U,
  base.weights = NULL,
  ebal.tol = 1e-06,
  ebal.maxit = 500
)
}
\arguments{
\item{target}{binary length-N vector: 1 = target/population, 0 = not in target.}

\item{observed}{binary length-N vector: 1 = observed/sample, 0 = not observed.}

\item{svd.U}{a matrix of left singular vectors from performing \code{svd()} on the kernel matrix.}

\item{base.weights}{optional positive length-N vector of base/design weights.
These are only used for sample units (\code{observed==1 & target==0});
all other units are treated as having base weight 1 inside entropy balancing.}

\item{ebal.tol}{tolerance level used by custom entropy balancing function \code{ebalance_custom}. Default is \code{1e-6}.}

\item{ebal.maxit}{maximum number of iterations in optimization search used by \code{ebalance_custom}. Default is \code{500}.}
}
\value{
A list containing:
\item{w}{A numeric vector of weights.}
\item{converged}{boolean indicating if \code{ebalance_custom} converged}
\item{ebal_error}{returns error message if \code{ebalance_custom} encounters an error}
}
\description{
Uses entropy balancing to find and return the weights that produce mean balance on \eqn{\phi(X_i)}, the expanded features of \eqn{X_i} using a given kernel \eqn{\phi(.)}, for the control or sample group and treated group or target population.
}
\examples{
\donttest{
#load and clean data
set.seed(123)
data("lalonde")
# Select a random subset of 500 rows
lalonde_sample <- sample(1:nrow(lalonde), 500, replace = FALSE)
lalonde <- lalonde[lalonde_sample, ]

xvars=c("age","black","educ","hisp","married","re74","re75","nodegr","u74","u75")

#need a kernel matrix to run SVD on then find weights with; so get that first with makeK.
#running makeK with the sampled units as the bases
K = makeK(allx = lalonde[,xvars], useasbases = 1-lalonde$nsw)

#SVD on this kernel and get matrix with left singular values
U = svd(K)$u
#Use the first 10 dimensions of U.
U2=U[,1:10]
getw.out=getw(target=lalonde$nsw, 
              observed=1-lalonde$nsw, 
              svd.U=U2)
 }
}
