% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wareki_seireki.R
\name{seireki2wareki}
\alias{seireki2wareki}
\alias{wareki2seireki}
\title{wareki}
\usage{
seireki2wareki(
  date,
  calendar = c("gregorian", "julian"),
  era = c("south", "north", "east", "heishi", "kyoto", "non"),
  one = c("kanji", "number"),
  leap.month = c("kanji", "hiragana"),
  sep = c("kanji", "/", "-")
)

wareki2seireki(
  date,
  calendar = c("gregorian", "julian"),
  era = c("south", "north", "east", "heishi", "kyoto", "non"),
  sep = "/"
)
}
\arguments{
\item{date}{Date to be converted. It should always include the year, month, and day.}

\item{calendar}{Select whether the calendar is Gregorian or Julian.}

\item{era}{Whether the Gengo of the Japanese calendar is the Southern or Northern dynasty system, the system used in the Kanto region, the Heike, and Kyoto respectively, or no era names.}

\item{one}{Whether to write the year in kanji as the first year or leave it as a number.}

\item{leap.month}{Whether to write leap months in Kanji or Hiragana.}

\item{sep}{The way the date is separated when the last date is written.}
}
\value{
String type date.
}
\description{
This is a set of functions for mutual conversion from Wareki that Japanese calendar dates to the Julian or Gregorian calendar dates. Before 1872, the Japanese calendar was used as the lunar calendar.
}
\examples{
wareki2seireki("\u4ee4\u548c3\u5e741\u67081\u65e5")
seireki2wareki("2021/1/1")
wareki2seireki("\u5929\u6b636\u5e743\u670813\u65e5", calendar = "julian")
seireki2wareki("1578/4/18")

}
\references{
The data for the Kyureki calendar and era names refer to the following data.

manakai/data-locale \url{https://github.com/manakai/data-locale}
}
