% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{preterm}
\alias{preterm}
\title{Meta-analysis of Cognitive Outcomes in Very Preterm Children}
\format{
A data frame with 61 rows and 18 columns. Each row represents a single study included in the meta-analysis.
The columns include:
\describe{
  \item{study}{First author and publication year.}
  \item{n_EPT.VPT}{Number of children born extremely or very preterm.}
  \item{mean_EPT.VPT}{Mean cognitive score in the EPT/VPT group.}
  \item{sd_EPT.VPT}{Standard deviation of cognitive scores in the EPT/VPT group.}
  \item{n_FT}{Number of children born full term.}
  \item{mean_FT}{Mean cognitive score in the full-term group.}
  \item{sd_FT}{Standard deviation of cognitive scores in the full-term group.}
  \item{SMD}{Standardized mean difference (Hedges’ g) comparing EPT/VPT with FT.}
  \item{seSMD}{Standard error of the standardized mean difference.}
  \item{mean_age}{Mean age at cognitive assessment.}
  \item{mean_ga}{Mean gestational age of the study population.}
  \item{mean_bw}{Mean birth weight of the study population.}
  \item{median_birth_year}{Median year of birth of the cohort included in the study.}
  \item{quality}{Methodological quality score based on a modified Newcastle–Ottawa Scale, ranging from 0 to 7, with higher values indicating better study quality.}
  \item{matched}{Indicator of whether the study used a matched design to compare preterm and full-term participants ("yes" or "no").}
  \item{birth_level}{Classification of the preterm subgroup included in the comparison: \code{VPT} for very preterm only, \code{EPT} for extremely preterm only, and \code{VPT_and_EPT} for combined very and extremely preterm groups.}
  \item{country}{Country where the study was conducted.}
  \item{analysis}{Indicator of whether the study contributed data to the primary analysis, secondary analysis, or both, as defined in Behboodi et al.}
}
}
\source{
Behboodi S, Chaimani A, Benhammou V, Twilhaar ES, Johnson S, Zeitlin J, Sentenac M.
Trends Over Time in Cognitive Outcomes of Children Born Very Preterm:
A Systematic Review and Meta-Analysis. JAMA Pediatrics. 2025;179(10):1074–1081.
doi:10.1001/jamapediatrics.2025.2221.
}
\description{
This dataset contains study-level data extracted from the systematic review and meta-analysis
Trends Over Time in Cognitive Outcomes of Children Born Very Preterm by Behboodi et al.
(JAMA Pediatrics, 2025). The review synthesizes evidence from observational cohort and matched
studies comparing cognitive outcomes of children born very preterm (VPT) or extremely preterm (EPT)
with children born at full term (FT).
}
\details{
The standardized mean difference (SMD) is a measure of the difference between two group
means, expressed in units of their pooled standard deviation. In this dataset it quantifies the
difference in mean cognitive test scores between children born preterm (EPT/VPT) and those born
full term (FT), with negative values indicating lower scores in the preterm group.

The SMD is calculated as Hedges’ g. First, Cohen’s d is computed as

\deqn{d = \frac{\bar{X}_{EPT.VPT} - \bar{X}_{FT}}{s_p},}

where \eqn{\bar{X}_{EPT.VPT}} and \eqn{\bar{X}_{FT}} are the mean cognitive scores in the EPT/VPT and
FT groups, respectively, and \eqn{s_p} is the pooled standard deviation.

The pooled standard deviation is given by

\deqn{s_p =
\sqrt{\frac{(n_{EPT.VPT}-1)\, s_{EPT.VPT}^2 + (n_{FT}-1)\, s_{FT}^2}
{n_{EPT.VPT} + n_{FT} - 2}}.}

Here, \eqn{n_{EPT.VPT}} and \eqn{n_{FT}} are the group sample sizes, and
\eqn{s_{EPT.VPT}} and \eqn{s_{FT}} are the corresponding standard deviations.

Cohen’s d is multiplied by the small-sample correction factor

\deqn{J = 1 - \frac{3}{4\,(n_{EPT.VPT} + n_{FT} - 2) - 1}}

to obtain Hedges’ g:

\deqn{SMD = g = J \times d.}

The standard error of the standardized mean difference (seSMD) measures the uncertainty of the
estimated SMD. Smaller values indicate more precise estimates of the difference between the
preterm (EPT/VPT) and full-term (FT) groups.

The seSMD is calculated as

\deqn{seSMD =
\sqrt{
J^2 \left(
\frac{n_{EPT.VPT} + n_{FT}}{n_{EPT.VPT}\, n_{FT}}
+
\frac{d^2}{2\,(n_{EPT.VPT} + n_{FT} - 2)}
\right)
}.}
}
\keyword{datasets}
