% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iunique.R
\name{i_unique}
\alias{i_unique}
\title{Iterator that extracts the unique elements from an iterable object}
\usage{
i_unique(object, digest = rlang::hash, ...)
}
\arguments{
\item{object}{an iterable object}

\item{digest}{Optionally specify a custom hash function
(e.g. \code{digest::digest}, \code{rlang::hash}). It should be a function
returning a character value.}

\item{...}{Extra arguments are forwarded to \link{iteror}.}
}
\value{
an iterator that returns only the unique elements from
\code{object}
}
\description{
Constructs an iterator that extracts each unique element in turn from an
iterable \code{object}. Order of the elements is maintained. This function is
an iterator analogue to \link{unique}.
}
\details{
NOTE: In order to determine whether an element is unique, a list of previous
unique elements is stored. In doing so, the list can potentially become large
if there are a large number of unique elements.
}
\examples{
it <- i_chain(rep(1, 4), rep(2, 5), 4:7, 2)
as.list(i_unique(it)) # 1 2 4 5 6 7

it2 <- iterators::iter(c('a', 'a', "A", "V"))
as.list(i_unique(it2)) # a A V

x <- as.character(gl(5, 10))
it_unique <- i_unique(x)
as.list(it_unique) # 1 2 3 4 5
}
\seealso{
i_dedup
}
