ks.rnorte <- function (M, quantiles=TRUE) {
  RES <- M$residuals
  Norm <- rnorm(1000, 0, sd(RES))
  if(quantiles == FALSE){
    ks.test(RES, Norm)
  } else {
    RESq <- quantile(RES, seq(0, 1, length=30))
    NORMq <- quantile(Norm, seq(0, 1, length=30))
    ks.test(RESq, NORMq)
  }
}
