% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_extract_classified_images.R
\name{ifcb_extract_classified_images}
\alias{ifcb_extract_classified_images}
\title{Extract Taxa Images from Classified Sample}
\usage{
ifcb_extract_classified_images(
  sample,
  classified_folder,
  roi_folder,
  out_folder,
  taxa = "All",
  threshold = "opt",
  overwrite = FALSE,
  scale_bar_um = NULL,
  scale_micron_factor = 1/3.4,
  scale_bar_position = "bottomright",
  scale_bar_color = "black",
  old_adc = FALSE,
  gamma = 1,
  normalize = FALSE,
  use_python = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{sample}{A character string specifying the sample name.}

\item{classified_folder}{A character string specifying the directory containing the classified files.}

\item{roi_folder}{A character string specifying the directory containing the ROI files.}

\item{out_folder}{A character string specifying the directory to save the extracted images.}

\item{taxa}{A character string specifying the taxa to extract. Default is "All".}

\item{threshold}{A character string specifying the threshold to use ("none", "opt", "adhoc"). Default is "opt".}

\item{overwrite}{A logical value indicating whether to overwrite existing PNG files. Default is FALSE.}

\item{scale_bar_um}{An optional numeric value specifying the length of the scale bar in micrometers. If NULL, no scale bar is added.}

\item{scale_micron_factor}{A numeric value defining the conversion factor from micrometers to pixels. Defaults to 1/3.4.}

\item{scale_bar_position}{A character string specifying the position of the scale bar in the image. Options are \code{"topright"}, \code{"topleft"}, \code{"bottomright"}, or \code{"bottomleft"}. Defaults to \code{"bottomright"}.}

\item{scale_bar_color}{A character string specifying the scale bar color. Options are \code{"black"} or \code{"white"}. Defaults to \code{"black"}.}

\item{old_adc}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Previously used to indicate old ADC format. ADC format is now auto-detected
from the HDR file and column count. This parameter is ignored.}

\item{gamma}{A numeric value for gamma correction applied to the image. Default is 1 (no correction). Values <1 brighten dark regions, while values >1 darken the image.}

\item{normalize}{A logical value indicating whether to apply min-max normalization to stretch pixel values to the full 0-255 range. Default is FALSE, preserving raw pixel values comparable to IFCB Dashboard output. See \code{\link[=ifcb_extract_pngs]{ifcb_extract_pngs()}} for details.}

\item{use_python}{Logical. If \code{TRUE}, attempts to read the \code{.mat} file using a Python-based method. Default is \code{FALSE}.}

\item{verbose}{A logical value indicating whether to print progress messages. Default is TRUE.}
}
\value{
No return value, called for side effects. Extracts and saves taxa images to a directory.
}
\description{
This function reads a classified sample file (\code{.mat}, \code{.h5}, or \code{.csv}) and
extracts specified taxa images from the corresponding ROI files,
saving each image in a specified directory. Supports \code{.mat} files generated
by \code{start_classify_batch_user_training} from the \code{ifcb-analysis} repository
(Sosik and Olson 2007), \code{.h5} files in IFCB Dashboard class_scores format,
and \code{.csv} files in \code{ClassiPyR}-compatible format.
}
\details{
If \code{use_python = TRUE}, the function tries to read the \code{.mat} file using \code{ifcb_read_mat()}, which relies on \code{SciPy}.
This approach may be faster than the default approach using \code{R.matlab::readMat()}, especially for large \code{.mat} files.
To enable this functionality, ensure Python is properly configured with the required dependencies.
You can initialize the Python environment and install necessary packages using \code{ifcb_py_install()}.

If \code{use_python = FALSE} or if \code{SciPy} is not available, the function falls back to using \code{R.matlab::readMat()}.
}
\examples{
\dontrun{
# Define the parameters
sample <- "D20230311T092911_IFCB135"
classified_folder <- "path/to/classified_folder"
roi_folder <- "path/to/roi_folder"
out_folder <- "path/to/outputdir"
taxa <- "All"  # or specify a particular taxa
threshold <- "opt"  # or specify another threshold

# Extract taxa images from the classified sample
ifcb_extract_classified_images(sample, classified_folder, roi_folder, out_folder, taxa, threshold)
}
}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_extract_pngs}} \code{\link{ifcb_extract_annotated_images}} \url{https://github.com/hsosik/ifcb-analysis}
}
