% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_classify_models.R
\name{ifcb_classify_models}
\alias{ifcb_classify_models}
\title{List Available CNN Models from a Gradio Classification Server}
\usage{
ifcb_classify_models(gradio_url = "https://irfcb-classify.hf.space")
}
\arguments{
\item{gradio_url}{A character string specifying the base URL of the Gradio
application. Default is \code{"https://irfcb-classify.hf.space"}, which is an
example Hugging Face Space with limited resources intended for testing and
demonstration. For large-scale classification, deploy your own instance of
the classification app with your own model (source code:
\url{https://github.com/EuropeanIFCBGroup/ifcb-inference-app}) and
pass its URL here.}
}
\value{
A character vector of available model names.
}
\description{
Queries the Gradio API to retrieve the names of all CNN models available
for IFCB image classification. These model names can be passed to the
\code{model_name} argument of \code{\link[=ifcb_classify_images]{ifcb_classify_images()}} and \code{\link[=ifcb_classify_sample]{ifcb_classify_sample()}}.
}
\examples{
\dontrun{
# List available models
models <- ifcb_classify_models()
print(models)

# Use a specific model for classification
result <- ifcb_classify_images("image.png", model_name = models[1])
}

}
\seealso{
\code{\link[=ifcb_classify_images]{ifcb_classify_images()}}, \code{\link[=ifcb_classify_sample]{ifcb_classify_sample()}}
}
