% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{score_test}
\alias{score_test}
\title{Score Test (Lagrange Multiplier Test)}
\usage{
score_test(score, fisher_info, null_value = NULL)
}
\arguments{
\item{score}{Numeric scalar or vector. The score function
\eqn{U(\theta_0) = \partial \ell / \partial \theta} evaluated at the
null value.}

\item{fisher_info}{Numeric scalar or matrix. The Fisher information
\eqn{I(\theta_0)} evaluated at the null value.}

\item{null_value}{Optional. The null hypothesis value, stored for
reference but not used in computation.}
}
\value{
A \code{hypothesis_test} object of subclass \code{score_test} containing:
\describe{
\item{stat}{The score statistic \eqn{S}}
\item{p.value}{P-value from chi-squared distribution}
\item{dof}{Degrees of freedom (1 for univariate, \eqn{k} for multivariate)}
\item{score}{The input score value(s)}
\item{fisher_info}{The input Fisher information}
\item{null_value}{The input null hypothesis value (if provided)}
}
}
\description{
Computes the score test statistic and p-value for testing whether a
parameter equals a hypothesized value, using the score function and
Fisher information evaluated at the null.
}
\details{
The score test is one of the "holy trinity" of likelihood-based tests,
alongside the Wald test (\code{\link[=wald_test]{wald_test()}}) and the likelihood ratio test
(\code{\link[=lrt]{lrt()}}). All three are asymptotically equivalent under \eqn{H_0}, but
they differ in what they require:

\itemize{
\item \strong{Wald test}: Needs the MLE and its standard error — requires
fitting the alternative model.
\item \strong{LRT}: Needs maximized log-likelihoods under both models —
requires fitting both.
\item \strong{Score test}: Needs only the score and information at
\eqn{\theta_0} — requires fitting only the null model.
}

This makes the score test computationally attractive when the null model
is simple but the alternative is expensive to fit.

For the univariate case:
\deqn{S = \frac{U(\theta_0)^2}{I(\theta_0)} \sim \chi^2_1}

For the multivariate case with \eqn{k} parameters:
\deqn{S = U(\theta_0)^\top I(\theta_0)^{-1} U(\theta_0) \sim \chi^2_k}

The function detects scalar vs. vector input and dispatches accordingly.
}
\examples{
# Univariate score test
score_test(score = 2, fisher_info = 2)

# Compare the trinity on the same problem
score_test(score = 2, fisher_info = 2)
wald_test(estimate = 6, se = sqrt(6/10), null_value = 5)

# Multivariate
score_test(score = c(1, 2), fisher_info = diag(c(1, 1)))

}
\seealso{
\code{\link[=wald_test]{wald_test()}}, \code{\link[=lrt]{lrt()}} for the other members of the trinity
}
