% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{is_significant_at}
\alias{is_significant_at}
\alias{is_significant_at.hypothesis_test}
\title{Check if a hypothesis test is significant at a given level}
\usage{
is_significant_at(x, alpha, ...)

\method{is_significant_at}{hypothesis_test}(x, alpha, ...)
}
\arguments{
\item{x}{a hypothesis test object}

\item{alpha}{significance level}

\item{...}{additional arguments passed to methods}
}
\value{
Logical indicating whether the test is significant at level
\code{alpha}.
}
\description{
Check if a hypothesis test is significant at a given level
}
\examples{
w <- wald_test(estimate = 2.5, se = 0.8)
is_significant_at(w, 0.05)
}
