% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapter_BR_ANA.R
\name{stations.hydro_service_BR_ANA}
\alias{stations.hydro_service_BR_ANA}
\title{ANA stations (Brazil) - cache-first with optional update from inventory}
\usage{
\method{stations}{hydro_service_BR_ANA}(x, ...)
}
\arguments{
\item{x}{A \code{hydro_service} created with \code{hydro_service("BR_ANA")}.}

\item{...}{Named arguments:
\itemize{
\item \code{zip_or_mdb}: path to \code{InventarioDD_MM_YYYY.zip} or \code{.mdb}
\item \code{dest_dir}: unzip destination (default: \code{"data-raw/BR_ANA"})
\item \code{cache_dir}: cache dir for RDS (default: user cache)
\item \code{update}: \code{TRUE} to rebuild from provided inventory
}}
}
\value{
A tibble with ANA station metadata.
}
\description{
Loads the cached ANA station catalogue (if present) or rebuilds it from a
locally downloaded SNIRH inventory (\code{InventarioDD_MM_YYYY.zip} / \code{.mdb})
when \code{update = TRUE}.
}
