% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_dgav_lookup.R
\name{tar_dgav_lookup}
\alias{tar_dgav_lookup}
\title{Look-up function for DGAV registry IDs/names}
\usage{
tar_dgav_lookup(df, mykeyvalues)
}
\arguments{
\item{df}{data frame with Name and azl number}

\item{mykeyvalues}{is a vector containing the key values to be looked up in the data frame.
These key values can be either numeric or character strings. The function processes each key
value individually to determine if it matches entries in the specified columns of the data frame}
}
\value{
a key or value, depending on what is wanted
}
\description{
This function takes a data frame `df` and a vector of
key values `mykeyvalues`. It returns an unnamed vector of corresponding
results by performing lookups in the data frame.
}
\examples{
# Example data
df <- data.frame(
  Name = c("Hans", "Maria", "Franz HUBER"),
  azl = c("1006341612", "1040405318", "1060707219"),
  stringsAsFactors = FALSE
)

tar_dgav_lookup(df, "HUBER")       # Should return "1060707219"
tar_dgav_lookup(df, "huber")       # Should also return "1060707219"
tar_dgav_lookup(df, "Franz")       # Should return "1060707219"
tar_dgav_lookup(df, 1006341612)  # Should return "Hans"
tar_dgav_lookup(df, c(1006341612, 1040405318)) # Should return "Hans"  "Maria"

# Function to handle inputs for data frame
}
