% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_projection.R
\name{hexify_build_icosa}
\alias{hexify_build_icosa}
\title{Initialize icosahedron geometry}
\usage{
hexify_build_icosa(
  vert0_lon = ISEA_VERT0_LON_DEG,
  vert0_lat = ISEA_VERT0_LAT_DEG,
  azimuth = ISEA_AZIMUTH_DEG
)
}
\arguments{
\item{vert0_lon}{Vertex 0 longitude in degrees (default ISEA_VERT0_LON_DEG)}

\item{vert0_lat}{Vertex 0 latitude in degrees (default ISEA_VERT0_LAT_DEG)}

\item{azimuth}{Azimuth rotation in degrees (default ISEA_AZIMUTH_DEG)}
}
\value{
Invisible NULL. Called for side effect.
}
\description{
Sets up the icosahedron state for ISEA projection. Uses standard ISEA3H
orientation by default (vertex 0 at 11.25E, 58.28N).
}
\details{
The icosahedron is initialized lazily at the C++ level when first needed.
Manual call is only required for non-standard orientations.
}
\examples{
# Use standard ISEA3H orientation
hexify_build_icosa()

# Custom orientation
hexify_build_icosa(vert0_lon = 0, vert0_lat = 90, azimuth = 0)
}
\seealso{
Other projection: 
\code{\link{hexify_face_centers}()},
\code{\link{hexify_forward}()},
\code{\link{hexify_forward_to_face}()},
\code{\link{hexify_get_precision}()},
\code{\link{hexify_inverse}()},
\code{\link{hexify_projection_stats}()},
\code{\link{hexify_set_precision}()},
\code{\link{hexify_set_verbose}()},
\code{\link{hexify_which_face}()}
}
\concept{projection}
