% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_helpers.R
\name{grid_rect}
\alias{grid_rect}
\title{Generate a rectangular grid of hexagons}
\usage{
grid_rect(bbox, grid)
}
\arguments{
\item{bbox}{Bounding box as c(xmin, ymin, xmax, ymax), or an sf/sfc object}

\item{grid}{A HexGridInfo object specifying the grid parameters}
}
\value{
sf object with hexagon polygons
}
\description{
Creates hexagon polygons covering a rectangular geographic region.
For H3 grids, all cells that overlap the bounding box are included
(not just cells whose center falls inside), ensuring full spatial coverage.
}
\examples{
grid <- hex_grid(area_km2 = 5000)
europe <- grid_rect(c(-10, 35, 30, 60), grid)
plot(europe)
}
\seealso{
\code{\link{grid_global}} for global grids
}
