% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{HexData-class}
\alias{HexData-class}
\title{HexData Class}
\description{
An S4 class representing hexified data. Contains the original user data
plus cell assignments from the hexification process.
}
\details{
HexData objects are created by \code{\link{hexify}}. The original data
is preserved in the \code{data} slot, while cell assignments are stored
separately in \code{cell_id} and \code{cell_center}.

Use \code{as.data.frame()} to get a combined data frame with cell columns.
}
\section{Slots}{

\describe{
\item{\code{data}}{Data frame or sf object. The original user data (untouched).}

\item{\code{grid}}{HexGridInfo object. The grid specification used.}

\item{\code{cell_id}}{Cell IDs for each row of data. Numeric for ISEA grids,
character for H3 grids.}

\item{\code{cell_center}}{Matrix. Two-column matrix (lon, lat) of cell centers.}
}}

\seealso{
\code{\link{hexify}} for creating HexData objects,
\code{\link{HexGridInfo-class}} for grid specifications
}
