% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_frt.R
\name{generate_permutations}
\alias{generate_permutations}
\title{Generate permutation distributions for FRT tests}
\usage{
generate_permutations(
  Y,
  Z,
  test.stat,
  Y0.mat,
  Y1.mat,
  B,
  n.cores,
  get.z.star = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{Y}{Outcome vector.}

\item{Z}{Treatment assignment vector (0/1).}

\item{test.stat}{Test statistic function taking (Y, Z, ...).}

\item{Y0.mat}{N x grid.size matrix of imputed control potential outcomes.}

\item{Y1.mat}{N x grid.size matrix of imputed treated potential outcomes.}

\item{B}{Number of permutations.}

\item{n.cores}{Number of cores for parallel computation.}

\item{get.z.star}{Optional function to generate permuted Z vectors.
If NULL, uses \code{sample(Z)}.}

\item{verbose}{Whether to display a progress bar. Default is TRUE.}

\item{...}{Additional arguments passed to \code{test.stat}.}
}
\value{
A list with components:
  \describe{
    \item{ks.obs}{Observed test statistic.}
    \item{ks.mat}{B x grid.size matrix of permuted test statistics.}
    \item{ci.p}{Vector of p-values for each grid point.}
  }
}
\description{
Core engine used by \code{FRTCI} and \code{FRTCI_interact} to compute
the randomization distribution of a test statistic under permuted
treatment assignments.
}
\keyword{internal}
